/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.exporter.prometheus.NameSanitizer;
import io.opentelemetry.exporter.prometheus.PrometheusType;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.metrics.data.LongExemplarData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.metrics.data.SummaryPointData;
import io.opentelemetry.sdk.metrics.data.ValueAtQuantile;
import io.opentelemetry.sdk.metrics.internal.data.exponentialhistogram.ExponentialHistogramData;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

abstract class Serializer {
    private final Predicate<String> metricNameFilter;

    static Serializer create(@Nullable String acceptHeader, Predicate<String> filter) {
        if (acceptHeader == null) {
            return new Prometheus004Serializer(filter);
        }
        for (String accepts : acceptHeader.split(",")) {
            if (!"application/openmetrics-text".equals(accepts.split(";")[0].trim())) continue;
            return new OpenMetrics100Serializer(filter);
        }
        return new Prometheus004Serializer(filter);
    }

    Serializer(Predicate<String> metricNameFilter) {
        this.metricNameFilter = metricNameFilter;
    }

    abstract String contentType();

    abstract String headerName(String var1, PrometheusType var2);

    abstract void writeHelp(Writer var1, String var2) throws IOException;

    abstract void writeTimestamp(Writer var1, long var2) throws IOException;

    abstract void writeExemplar(Writer var1, Collection<? extends ExemplarData> var2, double var3, double var5) throws IOException;

    abstract void writeEof(Writer var1) throws IOException;

    final void write(Collection<MetricData> metrics, OutputStream output) throws IOException {
        Map metricsByName = metrics.stream().filter(metric -> metric.getType() != MetricDataType.EXPONENTIAL_HISTOGRAM).filter(metric -> this.metricNameFilter.test(Serializer.metricName(metric))).collect(Collectors.groupingBy(metric -> this.headerName(NameSanitizer.INSTANCE.apply(metric.getName()), PrometheusType.forMetric(metric)), LinkedHashMap::new, Collectors.toList()));
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));){
            for (Map.Entry entry : metricsByName.entrySet()) {
                this.write((List)entry.getValue(), (String)entry.getKey(), writer);
            }
            this.writeEof(writer);
        }
    }

    private void write(List<MetricData> metrics, String headerName, Writer writer) throws IOException {
        PrometheusType type = PrometheusType.forMetric(metrics.get(0));
        String description = metrics.get(0).getDescription();
        writer.write("# TYPE ");
        writer.write(headerName);
        writer.write(32);
        writer.write(type.getTypeString());
        writer.write(10);
        writer.write("# HELP ");
        writer.write(headerName);
        writer.write(32);
        this.writeHelp(writer, description);
        writer.write(10);
        for (MetricData metric : metrics) {
            this.write(metric, writer);
        }
    }

    private void write(MetricData metric, Writer writer) throws IOException {
        String name = Serializer.metricName(metric);
        for (PointData pointData : Serializer.getPoints(metric)) {
            switch (metric.getType()) {
                case DOUBLE_SUM: 
                case DOUBLE_GAUGE: {
                    this.writePoint(writer, name, ((DoublePointData)pointData).getValue(), pointData.getAttributes(), pointData.getEpochNanos());
                    break;
                }
                case LONG_SUM: 
                case LONG_GAUGE: {
                    this.writePoint(writer, name, ((LongPointData)pointData).getValue(), pointData.getAttributes(), pointData.getEpochNanos());
                    break;
                }
                case HISTOGRAM: {
                    this.writeHistogram(writer, name, (HistogramPointData)pointData);
                    break;
                }
                case SUMMARY: {
                    this.writeSummary(writer, name, (SummaryPointData)pointData);
                    break;
                }
                case EXPONENTIAL_HISTOGRAM: {
                    throw new IllegalArgumentException("Can't happen");
                }
            }
        }
    }

    private void writeHistogram(Writer writer, String name, HistogramPointData point) throws IOException {
        this.writePoint(writer, name + "_count", point.getCount(), point.getAttributes(), point.getEpochNanos());
        this.writePoint(writer, name + "_sum", point.getSum(), point.getAttributes(), point.getEpochNanos());
        long cumulativeCount = 0L;
        List<Long> counts = point.getCounts();
        for (int i = 0; i < counts.size(); ++i) {
            double boundary = Serializer.getBucketUpperBound(point, i);
            this.writePoint(writer, name + "_bucket", cumulativeCount += counts.get(i).longValue(), point.getAttributes(), point.getEpochNanos(), "le", boundary, point.getExemplars(), Serializer.getBucketLowerBound(point, i), boundary);
        }
    }

    static double getBucketLowerBound(HistogramPointData point, int bucketIndex) {
        return bucketIndex > 0 ? point.getBoundaries().get(bucketIndex - 1) : Double.NEGATIVE_INFINITY;
    }

    static double getBucketUpperBound(HistogramPointData point, int bucketIndex) {
        List<Double> boundaries = point.getBoundaries();
        return bucketIndex < boundaries.size() ? boundaries.get(bucketIndex) : Double.POSITIVE_INFINITY;
    }

    private void writeSummary(Writer writer, String name, SummaryPointData point) throws IOException {
        this.writePoint(writer, name + "_count", point.getCount(), point.getAttributes(), point.getEpochNanos());
        this.writePoint(writer, name + "_sum", point.getSum(), point.getAttributes(), point.getEpochNanos());
        List<ValueAtQuantile> valueAtQuantiles = point.getValues();
        for (ValueAtQuantile valueAtQuantile : valueAtQuantiles) {
            this.writePoint(writer, name, valueAtQuantile.getValue(), point.getAttributes(), point.getEpochNanos(), "quantile", valueAtQuantile.getQuantile(), Collections.emptyList(), 0.0, 0.0);
        }
    }

    private void writePoint(Writer writer, String name, double value, Attributes attributes, long epochNanos) throws IOException {
        writer.write(name);
        Serializer.writeAttributes(writer, attributes);
        writer.write(32);
        Serializer.writeDouble(writer, value);
        writer.write(32);
        this.writeTimestamp(writer, epochNanos);
        writer.write(10);
    }

    private void writePoint(Writer writer, String name, double value, Attributes attributes, long epochNanos, String additionalAttrKey, double additionalAttrValue, Collection<? extends ExemplarData> exemplars, double minExemplar, double maxExemplar) throws IOException {
        writer.write(name);
        Serializer.writeAttributes(writer, attributes, additionalAttrKey, additionalAttrValue);
        writer.write(32);
        Serializer.writeDouble(writer, value);
        writer.write(32);
        this.writeTimestamp(writer, epochNanos);
        this.writeExemplar(writer, exemplars, minExemplar, maxExemplar);
        writer.write(10);
    }

    private static void writeAttributes(Writer writer, Attributes attributes) throws IOException {
        if (attributes.isEmpty()) {
            return;
        }
        writer.write(123);
        Serializer.writeAttributePairs(writer, attributes);
        writer.write(125);
    }

    private static void writeAttributes(Writer writer, Attributes attributes, String additionalAttrKey, double additionalAttrValue) throws IOException {
        writer.write(123);
        if (!attributes.isEmpty()) {
            Serializer.writeAttributePairs(writer, attributes);
            writer.write(44);
        }
        writer.write(additionalAttrKey);
        writer.write("=\"");
        Serializer.writeDouble(writer, additionalAttrValue);
        writer.write(34);
        writer.write(125);
    }

    private static void writeAttributePairs(final Writer writer, Attributes attributes) throws IOException {
        try {
            attributes.forEach(new BiConsumer<AttributeKey<?>, Object>(){
                private boolean wroteOne;

                @Override
                public void accept(AttributeKey<?> key, Object value) {
                    try {
                        if (this.wroteOne) {
                            writer.write(44);
                        } else {
                            this.wroteOne = true;
                        }
                        writer.write(NameSanitizer.INSTANCE.apply(key.getKey()));
                        writer.write("=\"");
                        Serializer.writeEscapedLabelValue(writer, value.toString());
                        writer.write(34);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private static void writeDouble(Writer writer, double d) throws IOException {
        if (d == Double.POSITIVE_INFINITY) {
            writer.write("+Inf");
        } else if (d == Double.NEGATIVE_INFINITY) {
            writer.write("-Inf");
        } else {
            writer.write(Double.toString(d));
        }
    }

    static void writeEscapedLabelValue(Writer writer, String s2) throws IOException {
        block5: for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            switch (c) {
                case '\\': {
                    writer.write("\\\\");
                    continue block5;
                }
                case '\"': {
                    writer.write("\\\"");
                    continue block5;
                }
                case '\n': {
                    writer.write("\\n");
                    continue block5;
                }
                default: {
                    writer.write(c);
                }
            }
        }
    }

    static Collection<? extends PointData> getPoints(MetricData metricData) {
        switch (metricData.getType()) {
            case DOUBLE_GAUGE: {
                return metricData.getDoubleGaugeData().getPoints();
            }
            case DOUBLE_SUM: {
                return metricData.getDoubleSumData().getPoints();
            }
            case LONG_GAUGE: {
                return metricData.getLongGaugeData().getPoints();
            }
            case LONG_SUM: {
                return metricData.getLongSumData().getPoints();
            }
            case SUMMARY: {
                return metricData.getSummaryData().getPoints();
            }
            case HISTOGRAM: {
                return metricData.getHistogramData().getPoints();
            }
            case EXPONENTIAL_HISTOGRAM: {
                return ExponentialHistogramData.fromMetricData(metricData).getPoints();
            }
        }
        return Collections.emptyList();
    }

    private static String metricName(MetricData metric) {
        PrometheusType type = PrometheusType.forMetric(metric);
        String name = NameSanitizer.INSTANCE.apply(metric.getName());
        if (type == PrometheusType.COUNTER) {
            name = name + "_total";
        }
        return name;
    }

    private static double getExemplarValue(ExemplarData exemplar) {
        return exemplar instanceof DoubleExemplarData ? ((DoubleExemplarData)exemplar).getValue() : (double)((LongExemplarData)exemplar).getValue();
    }

    static class Prometheus004Serializer
    extends Serializer {
        Prometheus004Serializer(Predicate<String> metricNameFilter) {
            super(metricNameFilter);
        }

        @Override
        String contentType() {
            return "text/plain; version=0.0.4; charset=utf-8";
        }

        @Override
        String headerName(String name, PrometheusType type) {
            if (type == PrometheusType.COUNTER) {
                return name + "_total";
            }
            return name;
        }

        @Override
        void writeHelp(Writer writer, String help) throws IOException {
            block4: for (int i = 0; i < help.length(); ++i) {
                char c = help.charAt(i);
                switch (c) {
                    case '\\': {
                        writer.write("\\\\");
                        continue block4;
                    }
                    case '\n': {
                        writer.write("\\n");
                        continue block4;
                    }
                    default: {
                        writer.write(c);
                    }
                }
            }
        }

        @Override
        void writeTimestamp(Writer writer, long timestampNanos) throws IOException {
            writer.write(Long.toString(TimeUnit.NANOSECONDS.toMillis(timestampNanos)));
        }

        @Override
        void writeExemplar(Writer writer, Collection<? extends ExemplarData> exemplars, double minExemplar, double maxExemplar) {
        }

        @Override
        void writeEof(Writer writer) {
        }
    }

    static class OpenMetrics100Serializer
    extends Serializer {
        OpenMetrics100Serializer(Predicate<String> metricNameFilter) {
            super(metricNameFilter);
        }

        @Override
        String contentType() {
            return "application/openmetrics-text; version=1.0.0; charset=utf-8";
        }

        @Override
        String headerName(String name, PrometheusType type) {
            return name;
        }

        @Override
        void writeHelp(Writer writer, String description) throws IOException {
            OpenMetrics100Serializer.writeEscapedLabelValue(writer, description);
        }

        @Override
        void writeTimestamp(Writer writer, long timestampNanos) throws IOException {
            long timestampMillis = TimeUnit.NANOSECONDS.toMillis(timestampNanos);
            writer.write(Long.toString(timestampMillis / 1000L));
            writer.write(".");
            long millis = timestampMillis % 1000L;
            if (millis < 100L) {
                writer.write(48);
            }
            if (millis < 10L) {
                writer.write(48);
            }
            writer.write(Long.toString(millis));
        }

        @Override
        void writeExemplar(Writer writer, Collection<? extends ExemplarData> exemplars, double minExemplar, double maxExemplar) throws IOException {
            for (ExemplarData exemplarData : exemplars) {
                double value = Serializer.getExemplarValue(exemplarData);
                if (!(value > minExemplar) || !(value <= maxExemplar)) continue;
                writer.write(" # {");
                SpanContext spanContext = exemplarData.getSpanContext();
                if (spanContext.isValid()) {
                    writer.write("span_id=\"");
                    writer.write(spanContext.getSpanId());
                    writer.write("\",trace_id=\"");
                    writer.write(spanContext.getTraceId());
                    writer.write(34);
                }
                writer.write("} ");
                Serializer.writeDouble(writer, value);
                writer.write(32);
                this.writeTimestamp(writer, exemplarData.getEpochNanos());
                return;
            }
        }

        @Override
        void writeEof(Writer writer) throws IOException {
            writer.write("# EOF\n");
        }
    }
}

