/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.testing.assertj.AssertUtil;
import io.opentelemetry.sdk.testing.assertj.AttributeAssertion;
import io.opentelemetry.sdk.testing.assertj.AttributesAssert;
import io.opentelemetry.sdk.testing.assertj.EventDataAssert;
import io.opentelemetry.sdk.testing.assertj.OpenTelemetryAssertions;
import io.opentelemetry.sdk.testing.assertj.StatusDataAssert;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.data.StatusData;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.ListAssert;

public final class SpanDataAssert
extends AbstractAssert<SpanDataAssert, SpanData> {
    SpanDataAssert(@Nullable SpanData actual) {
        super((Object)actual, SpanDataAssert.class);
    }

    public SpanDataAssert hasTraceId(String traceId) {
        this.isNotNull();
        if (!((SpanData)this.actual).getTraceId().equals(traceId)) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getTraceId(), traceId, "Expected span [%s] to have trace ID <%s> but was <%s>", new Object[]{((SpanData)this.actual).getName(), traceId, ((SpanData)this.actual).getTraceId()});
        }
        return this;
    }

    public SpanDataAssert hasSpanId(String spanId) {
        this.isNotNull();
        if (!((SpanData)this.actual).getSpanId().equals(spanId)) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getSpanId(), spanId, "Expected span [%s] to have span ID <%s> but was <%s>", new Object[]{((SpanData)this.actual).getName(), spanId, ((SpanData)this.actual).getSpanId()});
        }
        return this;
    }

    public SpanDataAssert isSampled() {
        this.isNotNull();
        if (!((SpanData)this.actual).getSpanContext().isSampled()) {
            this.failWithMessage("Expected span [%s] to be sampled but was not.", new Object[]{((SpanData)this.actual).getName()});
        }
        return this;
    }

    public SpanDataAssert isNotSampled() {
        this.isNotNull();
        if (((SpanData)this.actual).getSpanContext().isSampled()) {
            this.failWithMessage("Expected span [%s] to not be sampled but it was.", new Object[]{((SpanData)this.actual).getName()});
        }
        return this;
    }

    public SpanDataAssert hasTraceState(TraceState traceState) {
        this.isNotNull();
        if (!((SpanData)this.actual).getSpanContext().getTraceState().equals(traceState)) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getSpanContext().getTraceState(), traceState, "Expected span [%s] to have trace state <%s> but was <%s>", new Object[]{((SpanData)this.actual).getName(), traceState, ((SpanData)this.actual).getSpanContext().getTraceState()});
        }
        return this;
    }

    public SpanDataAssert hasParentSpanId(String parentSpanId) {
        this.isNotNull();
        String actualParentSpanId = ((SpanData)this.actual).getParentSpanId();
        if (!actualParentSpanId.equals(parentSpanId)) {
            this.failWithActualExpectedAndMessage(actualParentSpanId, parentSpanId, "Expected span [%s] to have parent span ID <%s> but was <%s>", new Object[]{((SpanData)this.actual).getName(), parentSpanId, actualParentSpanId});
        }
        return this;
    }

    public SpanDataAssert hasParent(SpanData parent) {
        return this.hasParentSpanId(parent.getSpanId());
    }

    public SpanDataAssert hasNoParent() {
        this.isNotNull();
        String actualParentSpanId = ((SpanData)this.actual).getParentSpanId();
        if (!actualParentSpanId.equals(SpanId.getInvalid())) {
            this.failWithActualExpectedAndMessage(actualParentSpanId, SpanId.getInvalid(), "Expected span [%s] to have no parent but had parent span ID <%s>", new Object[]{((SpanData)this.actual).getName(), actualParentSpanId});
        }
        return this;
    }

    public SpanDataAssert hasResource(Resource resource) {
        this.isNotNull();
        if (!((SpanData)this.actual).getResource().equals(resource)) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getResource(), resource, "Expected span [%s] to have resource <%s> but was <%s>", new Object[]{((SpanData)this.actual).getName(), resource, ((SpanData)this.actual).getResource()});
        }
        return this;
    }

    @Deprecated
    public SpanDataAssert hasInstrumentationLibraryInfo(InstrumentationLibraryInfo instrumentationLibraryInfo) {
        this.isNotNull();
        if (!((SpanData)this.actual).getInstrumentationLibraryInfo().equals(instrumentationLibraryInfo)) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getInstrumentationLibraryInfo(), instrumentationLibraryInfo, "Expected span [%s] to have instrumentation library info <%s> but was <%s>", new Object[]{((SpanData)this.actual).getName(), instrumentationLibraryInfo, ((SpanData)this.actual).getInstrumentationLibraryInfo()});
        }
        return this;
    }

    public SpanDataAssert hasInstrumentationScopeInfo(InstrumentationScopeInfo instrumentationScopeInfo) {
        this.isNotNull();
        if (!((SpanData)this.actual).getInstrumentationScopeInfo().equals(instrumentationScopeInfo)) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getInstrumentationScopeInfo(), instrumentationScopeInfo, "Expected span [%s] to have instrumentation scope info <%s> but was <%s>", new Object[]{((SpanData)this.actual).getName(), instrumentationScopeInfo, ((SpanData)this.actual).getInstrumentationScopeInfo()});
        }
        return this;
    }

    public SpanDataAssert hasName(String name) {
        this.isNotNull();
        if (!((SpanData)this.actual).getName().equals(name)) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getName(), name, "Expected span to have name <%s> but was <%s>", new Object[]{name, ((SpanData)this.actual).getName()});
        }
        return this;
    }

    public SpanDataAssert hasKind(SpanKind kind) {
        this.isNotNull();
        if (!((SpanData)this.actual).getKind().equals((Object)kind)) {
            this.failWithActualExpectedAndMessage((Object)((SpanData)this.actual).getKind(), (Object)kind, "Expected span [%s] to have kind <%s> but was <%s>", new Object[]{((SpanData)this.actual).getName(), kind, ((SpanData)this.actual).getKind()});
        }
        return this;
    }

    public SpanDataAssert startsAt(long startEpochNanos) {
        this.isNotNull();
        if (((SpanData)this.actual).getStartEpochNanos() != startEpochNanos) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getStartEpochNanos(), startEpochNanos, "Expected span [%s] to have start epoch <%s> nanos but was <%s>", new Object[]{((SpanData)this.actual).getName(), startEpochNanos, ((SpanData)this.actual).getStartEpochNanos()});
        }
        return this;
    }

    public SpanDataAssert startsAt(long startEpoch, TimeUnit unit) {
        return this.startsAt(unit.toNanos(startEpoch));
    }

    public SpanDataAssert startsAt(Instant timestamp) {
        return this.startsAt(SpanDataAssert.toNanos(timestamp));
    }

    public <T> SpanDataAssert hasAttribute(AttributeKey<T> key, T value) {
        return this.hasAttribute(OpenTelemetryAssertions.equalTo(key, value));
    }

    public SpanDataAssert hasAttribute(AttributeAssertion attributeAssertion) {
        this.isNotNull();
        Set<AttributeKey<?>> actualKeys = ((SpanData)this.actual).getAttributes().asMap().keySet();
        AttributeKey<?> key = attributeAssertion.getKey();
        ((AbstractCollectionAssert)OpenTelemetryAssertions.assertThat(actualKeys).as("span [%s] attribute keys", new Object[]{((SpanData)this.actual).getName()})).contains((Object[])new AttributeKey[]{key});
        Object value = ((SpanData)this.actual).getAttributes().get(key);
        AbstractAssert<?, ?> assertion = AttributeAssertion.attributeValueAssertion(key, value);
        attributeAssertion.getAssertion().accept(assertion);
        return this;
    }

    public SpanDataAssert hasAttributes(Attributes attributes) {
        this.isNotNull();
        if (!AssertUtil.attributesAreEqual(((SpanData)this.actual).getAttributes(), attributes)) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getAttributes(), attributes, "Expected span [%s] to have attributes <%s> but was <%s>", new Object[]{((SpanData)this.actual).getName(), attributes, ((SpanData)this.actual).getAttributes()});
        }
        return this;
    }

    @SafeVarargs
    public final SpanDataAssert hasAttributes(Map.Entry<? extends AttributeKey<?>, ?> ... entries) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        for (Map.Entry<AttributeKey<?>, ?> entry : entries) {
            attributesBuilder.put(entry.getKey(), entry.getValue());
        }
        Attributes attributes = attributesBuilder.build();
        return this.hasAttributes(attributes);
    }

    public SpanDataAssert hasAttributesSatisfying(Consumer<Attributes> attributes) {
        this.isNotNull();
        ((AttributesAssert)((Object)OpenTelemetryAssertions.assertThat(((SpanData)this.actual).getAttributes()).as("attributes", new Object[0]))).satisfies(new Consumer[]{attributes});
        return this;
    }

    public SpanDataAssert hasAttributesSatisfyingExactly(AttributeAssertion ... assertions) {
        return this.hasAttributesSatisfyingExactly(Arrays.asList(assertions));
    }

    public SpanDataAssert hasAttributesSatisfyingExactly(Iterable<AttributeAssertion> assertions) {
        Set<AttributeKey<?>> actualKeys = ((SpanData)this.actual).getAttributes().asMap().keySet();
        HashSet checkedKeys = new HashSet();
        for (AttributeAssertion attributeAssertion : assertions) {
            AttributeKey<?> key = attributeAssertion.getKey();
            Object value = ((SpanData)this.actual).getAttributes().get(key);
            if (value != null) {
                checkedKeys.add(key);
            }
            AbstractAssert<?, ?> assertion = AttributeAssertion.attributeValueAssertion(key, value);
            attributeAssertion.getAssertion().accept(assertion);
        }
        ((AbstractCollectionAssert)OpenTelemetryAssertions.assertThat(actualKeys).as("span [%s] attribute keys", new Object[]{((SpanData)this.actual).getName()})).containsExactlyInAnyOrderElementsOf(checkedKeys);
        return this;
    }

    public SpanDataAssert hasException(Throwable exception) {
        EventData exceptionEvent = ((SpanData)this.actual).getEvents().stream().filter(event -> event.getName().equals("exception")).findFirst().orElse(null);
        if (exceptionEvent == null) {
            this.failWithMessage("Expected span [%s] to have an exception event but only had events <%s>", new Object[]{((SpanData)this.actual).getName(), ((SpanData)this.actual).getEvents()});
            return this;
        }
        ((AttributesAssert)((Object)OpenTelemetryAssertions.assertThat(exceptionEvent.getAttributes()).as("exception.type", new Object[0]))).containsEntry(SemanticAttributes.EXCEPTION_TYPE, exception.getClass().getCanonicalName());
        if (exception.getMessage() != null) {
            ((AttributesAssert)((Object)OpenTelemetryAssertions.assertThat(exceptionEvent.getAttributes()).as("exception.message", new Object[0]))).containsEntry(SemanticAttributes.EXCEPTION_MESSAGE, exception.getMessage());
        }
        String stackTrace = exceptionEvent.getAttributes().get(SemanticAttributes.EXCEPTION_STACKTRACE);
        ((AbstractStringAssert)OpenTelemetryAssertions.assertThat((String)stackTrace).as("exception.stacktrace", new Object[0])).isNotNull();
        return this;
    }

    public SpanDataAssert hasEvents(Iterable<EventData> events) {
        this.isNotNull();
        ((ListAssert)OpenTelemetryAssertions.assertThat(((SpanData)this.actual).getEvents()).withFailMessage("Expected span [%s] to have events <%s> but was <%s>", new Object[]{((SpanData)this.actual).getName(), events, ((SpanData)this.actual).getEvents()})).containsExactlyInAnyOrderElementsOf(events);
        return this;
    }

    public SpanDataAssert hasEvents(EventData ... events) {
        return this.hasEvents(Arrays.asList(events));
    }

    public SpanDataAssert hasEventsSatisfying(Consumer<List<? extends EventData>> condition) {
        this.isNotNull();
        OpenTelemetryAssertions.assertThat(((SpanData)this.actual).getEvents()).satisfies(new Consumer[]{condition});
        return this;
    }

    @SafeVarargs
    public final SpanDataAssert hasEventsSatisfyingExactly(Consumer<EventDataAssert> ... assertions) {
        OpenTelemetryAssertions.assertThat(((SpanData)this.actual).getEvents()).hasSize(assertions.length);
        for (int i = 0; i < assertions.length; ++i) {
            assertions[i].accept(new EventDataAssert(((SpanData)this.actual).getEvents().get(i)));
        }
        return this;
    }

    public SpanDataAssert hasLinks(Iterable<LinkData> links) {
        this.isNotNull();
        ((ListAssert)OpenTelemetryAssertions.assertThat(((SpanData)this.actual).getLinks()).withFailMessage("Expected span [%s] to have links <%s> but was <%s>", new Object[]{((SpanData)this.actual).getName(), links, ((SpanData)this.actual).getLinks()})).containsExactlyInAnyOrderElementsOf(links);
        return this;
    }

    public SpanDataAssert hasLinks(LinkData ... links) {
        return this.hasLinks(Arrays.asList(links));
    }

    public SpanDataAssert hasLinksSatisfying(Consumer<List<? extends LinkData>> condition) {
        this.isNotNull();
        OpenTelemetryAssertions.assertThat(((SpanData)this.actual).getLinks()).satisfies(new Consumer[]{condition});
        return this;
    }

    public SpanDataAssert hasStatus(StatusData status) {
        this.isNotNull();
        if (!((SpanData)this.actual).getStatus().equals(status)) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getStatus(), status, "Expected span [%s] to have status <%s> but was <%s>", new Object[]{((SpanData)this.actual).getName(), status, ((SpanData)this.actual).getStatus()});
        }
        return this;
    }

    public SpanDataAssert hasStatusSatisfying(Consumer<StatusDataAssert> condition) {
        this.isNotNull();
        StatusDataAssert statusDataAssert = new StatusDataAssert(((SpanData)this.actual).getStatus());
        condition.accept(statusDataAssert);
        return this;
    }

    public SpanDataAssert endsAt(long endEpochNanos) {
        this.isNotNull();
        if (((SpanData)this.actual).getEndEpochNanos() != endEpochNanos) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getEndEpochNanos(), endEpochNanos, "Expected span [%s] to have end epoch <%s> nanos but was <%s>", new Object[]{((SpanData)this.actual).getName(), endEpochNanos, ((SpanData)this.actual).getEndEpochNanos()});
        }
        return this;
    }

    public SpanDataAssert endsAt(long startEpoch, TimeUnit unit) {
        return this.endsAt(unit.toNanos(startEpoch));
    }

    public SpanDataAssert endsAt(Instant timestamp) {
        return this.endsAt(SpanDataAssert.toNanos(timestamp));
    }

    public SpanDataAssert hasEnded() {
        this.isNotNull();
        if (!((SpanData)this.actual).hasEnded()) {
            this.failWithMessage("Expected span [%s] to have ended but did not", new Object[]{((SpanData)this.actual).getName()});
        }
        return this;
    }

    public SpanDataAssert hasNotEnded() {
        this.isNotNull();
        if (((SpanData)this.actual).hasEnded()) {
            this.failWithMessage("Expected span [%s] to have not ended but did has", new Object[]{((SpanData)this.actual).getName()});
        }
        return this;
    }

    public SpanDataAssert hasTotalRecordedEvents(int totalRecordedEvents) {
        this.isNotNull();
        if (((SpanData)this.actual).getTotalRecordedEvents() != totalRecordedEvents) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getTotalRecordedEvents(), totalRecordedEvents, "Expected span [%s] to have recorded <%s> total events but did not", new Object[]{((SpanData)this.actual).getName(), totalRecordedEvents, ((SpanData)this.actual).getTotalRecordedEvents()});
        }
        return this;
    }

    public SpanDataAssert hasTotalRecordedLinks(int totalRecordedLinks) {
        this.isNotNull();
        if (((SpanData)this.actual).getTotalRecordedLinks() != totalRecordedLinks) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getTotalRecordedLinks(), totalRecordedLinks, "Expected span [%s] to have recorded <%s> total links but did not", new Object[]{((SpanData)this.actual).getName(), totalRecordedLinks, ((SpanData)this.actual).getTotalRecordedLinks()});
        }
        return this;
    }

    public SpanDataAssert hasTotalAttributeCount(int totalAttributeCount) {
        this.isNotNull();
        if (((SpanData)this.actual).getTotalAttributeCount() != totalAttributeCount) {
            this.failWithActualExpectedAndMessage(((SpanData)this.actual).getTotalAttributeCount(), totalAttributeCount, "Expected span [%s] to have recorded <%s> total attributes but did not", new Object[]{((SpanData)this.actual).getName(), totalAttributeCount, ((SpanData)this.actual).getTotalAttributeCount()});
        }
        return this;
    }

    private static long toNanos(Instant timestamp) {
        return TimeUnit.SECONDS.toNanos(timestamp.getEpochSecond()) + (long)timestamp.getNano();
    }
}

