/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.autoconfigure.NamedSpiManager;
import io.opentelemetry.sdk.autoconfigure.SpanExporterConfiguration;
import io.opentelemetry.sdk.autoconfigure.SpiUtil;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSamplerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanLimits;
import io.opentelemetry.sdk.trace.SpanLimitsBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessorBuilder;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

final class TracerProviderConfiguration {
    private static final double DEFAULT_TRACEIDRATIO_SAMPLE_RATIO = 1.0;
    private static final String PARENTBASED_ALWAYS_ON = "parentbased_always_on";

    static void configureTracerProvider(SdkTracerProviderBuilder tracerProviderBuilder, ConfigProperties config, ClassLoader serviceClassLoader, MeterProvider meterProvider, BiFunction<? super SpanExporter, ConfigProperties, ? extends SpanExporter> spanExporterCustomizer, BiFunction<? super Sampler, ConfigProperties, ? extends Sampler> samplerCustomizer) {
        tracerProviderBuilder.setSpanLimits(TracerProviderConfiguration.configureSpanLimits(config));
        String sampler = config.getString("otel.traces.sampler", PARENTBASED_ALWAYS_ON);
        tracerProviderBuilder.setSampler(samplerCustomizer.apply(TracerProviderConfiguration.configureSampler(sampler, config, serviceClassLoader), config));
        Map<String, SpanExporter> exportersByName = SpanExporterConfiguration.configureSpanExporters(config, serviceClassLoader, meterProvider, spanExporterCustomizer);
        TracerProviderConfiguration.configureSpanProcessors(config, exportersByName, meterProvider).forEach(tracerProviderBuilder::addSpanProcessor);
    }

    static List<SpanProcessor> configureSpanProcessors(ConfigProperties config, Map<String, SpanExporter> exportersByName, MeterProvider meterProvider) {
        HashMap<String, SpanExporter> exportersByNameCopy = new HashMap<String, SpanExporter>(exportersByName);
        ArrayList<SpanProcessor> spanProcessors = new ArrayList<SpanProcessor>();
        SpanExporter exporter = (SpanExporter)exportersByNameCopy.remove("logging");
        if (exporter != null) {
            spanProcessors.add(SimpleSpanProcessor.create(exporter));
        }
        if (!exportersByNameCopy.isEmpty()) {
            SpanExporter compositeSpanExporter = SpanExporter.composite(exportersByNameCopy.values());
            spanProcessors.add(TracerProviderConfiguration.configureBatchSpanProcessor(config, compositeSpanExporter, meterProvider));
        }
        return spanProcessors;
    }

    static BatchSpanProcessor configureBatchSpanProcessor(ConfigProperties config, SpanExporter exporter, MeterProvider meterProvider) {
        Duration timeout2;
        Integer maxExportBatch;
        Integer maxQueue;
        BatchSpanProcessorBuilder builder = BatchSpanProcessor.builder(exporter).setMeterProvider(meterProvider);
        Duration scheduleDelay = config.getDuration("otel.bsp.schedule.delay");
        if (scheduleDelay != null) {
            builder.setScheduleDelay(scheduleDelay);
        }
        if ((maxQueue = config.getInt("otel.bsp.max.queue.size")) != null) {
            builder.setMaxQueueSize(maxQueue);
        }
        if ((maxExportBatch = config.getInt("otel.bsp.max.export.batch.size")) != null) {
            builder.setMaxExportBatchSize(maxExportBatch);
        }
        if ((timeout2 = config.getDuration("otel.bsp.export.timeout")) != null) {
            builder.setExporterTimeout(timeout2);
        }
        return builder.build();
    }

    static SpanLimits configureSpanLimits(ConfigProperties config) {
        Integer maxLinks;
        Integer maxEvents;
        Integer maxSpanAttrs;
        Integer maxAttrs;
        Integer maxSpanAttrLength;
        SpanLimitsBuilder builder = SpanLimits.builder();
        Integer maxAttrLength = config.getInt("otel.attribute.value.length.limit");
        if (maxAttrLength != null) {
            builder.setMaxAttributeValueLength(maxAttrLength);
        }
        if ((maxSpanAttrLength = config.getInt("otel.span.attribute.value.length.limit")) != null) {
            builder.setMaxAttributeValueLength(maxSpanAttrLength);
        }
        if ((maxAttrs = config.getInt("otel.attribute.count.limit")) != null) {
            builder.setMaxNumberOfAttributes(maxAttrs);
            builder.setMaxNumberOfAttributesPerEvent(maxAttrs);
            builder.setMaxNumberOfAttributesPerLink(maxAttrs);
        }
        if ((maxSpanAttrs = config.getInt("otel.span.attribute.count.limit")) != null) {
            builder.setMaxNumberOfAttributes(maxSpanAttrs);
        }
        if ((maxEvents = config.getInt("otel.span.event.count.limit")) != null) {
            builder.setMaxNumberOfEvents(maxEvents);
        }
        if ((maxLinks = config.getInt("otel.span.link.count.limit")) != null) {
            builder.setMaxNumberOfLinks(maxLinks);
        }
        return builder.build();
    }

    static Sampler configureSampler(String sampler, ConfigProperties config, ClassLoader serviceClassLoader) {
        NamedSpiManager<Sampler> spiSamplersManager = SpiUtil.loadConfigurable(ConfigurableSamplerProvider.class, ConfigurableSamplerProvider::getName, ConfigurableSamplerProvider::createSampler, config, serviceClassLoader);
        switch (sampler) {
            case "always_on": {
                return Sampler.alwaysOn();
            }
            case "always_off": {
                return Sampler.alwaysOff();
            }
            case "traceidratio": {
                double ratio = config.getDouble("otel.traces.sampler.arg", 1.0);
                return Sampler.traceIdRatioBased(ratio);
            }
            case "parentbased_always_on": {
                return Sampler.parentBased(Sampler.alwaysOn());
            }
            case "parentbased_always_off": {
                return Sampler.parentBased(Sampler.alwaysOff());
            }
            case "parentbased_traceidratio": {
                double ratio = config.getDouble("otel.traces.sampler.arg", 1.0);
                return Sampler.parentBased(Sampler.traceIdRatioBased(ratio));
            }
        }
        Sampler spiSampler = spiSamplersManager.getByName(sampler);
        if (spiSampler == null) {
            throw new ConfigurationException("Unrecognized value for otel.traces.sampler: " + sampler);
        }
        return spiSampler;
    }

    private TracerProviderConfiguration() {
    }
}

