/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.AutoFinal;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.tools.ClosureUtils;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class AutoFinalASTTransformation
extends AbstractASTTransformation {
    private static final Class MY_CLASS = AutoFinal.class;
    private static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    private static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private AnnotatedNode candidate;

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source2) {
        this.init(nodes, source2);
        ClassCodeVisitorSupport visitor = this.createVisitor();
        this.process(nodes, visitor);
    }

    private ClassCodeVisitorSupport createVisitor() {
        return new ClassCodeVisitorSupport(){

            @Override
            public void visitClosureExpression(ClosureExpression expression) {
                Parameter[] origParams;
                if (expression.isSynthetic()) {
                    return;
                }
                for (Parameter p : origParams = ClosureUtils.getParametersSafe(expression)) {
                    p.setModifiers(p.getModifiers() | 0x10);
                }
                super.visitClosureExpression(expression);
            }

            @Override
            protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
                if (AutoFinalASTTransformation.this.hasNoExplicitAutoFinal(node) || AutoFinalASTTransformation.this.candidate == node) {
                    super.visitConstructorOrMethod(node, isConstructor);
                }
            }

            @Override
            public void visitField(FieldNode node) {
                if (AutoFinalASTTransformation.this.hasNoExplicitAutoFinal(node) || AutoFinalASTTransformation.this.candidate == node) {
                    super.visitField(node);
                }
            }

            @Override
            public void visitDeclarationExpression(DeclarationExpression expr) {
                if (AutoFinalASTTransformation.this.hasNoExplicitAutoFinal(expr) || AutoFinalASTTransformation.this.candidate == expr) {
                    super.visitDeclarationExpression(expr);
                }
            }

            @Override
            protected SourceUnit getSourceUnit() {
                return AutoFinalASTTransformation.this.sourceUnit;
            }
        };
    }

    private void process(ASTNode[] nodes, ClassCodeVisitorSupport visitor) {
        this.candidate = (AnnotatedNode)nodes[1];
        AnnotationNode node = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(node.getClassNode())) {
            return;
        }
        if (this.candidate instanceof ClassNode) {
            this.processClass((ClassNode)this.candidate, visitor);
        } else if (this.candidate instanceof MethodNode) {
            this.processConstructorOrMethod((MethodNode)this.candidate, visitor);
        } else if (this.candidate instanceof FieldNode) {
            this.processField((FieldNode)this.candidate, visitor);
        } else if (this.candidate instanceof DeclarationExpression) {
            this.processLocalVariable((DeclarationExpression)this.candidate, visitor);
        }
    }

    private void processClass(ClassNode cNode, ClassCodeVisitorSupport visitor) {
        if (!this.isEnabled(cNode)) {
            return;
        }
        if (cNode.isInterface()) {
            this.addError("Error processing interface '" + cNode.getName() + "'. " + MY_TYPE_NAME + " only allowed for classes.", cNode);
            return;
        }
        for (ConstructorNode cn : cNode.getDeclaredConstructors()) {
            if (!this.hasNoExplicitAutoFinal(cn)) continue;
            this.processConstructorOrMethod(cn, visitor);
        }
        for (MethodNode mn : cNode.getAllDeclaredMethods()) {
            if (!this.hasNoExplicitAutoFinal(mn)) continue;
            this.processConstructorOrMethod(mn, visitor);
        }
        Iterator<InnerClassNode> it = cNode.getInnerClasses();
        while (it.hasNext()) {
            InnerClassNode in = it.next();
            if (!in.getAnnotations(MY_TYPE).isEmpty()) continue;
            this.processClass(in, visitor);
        }
        visitor.visitClass(cNode);
    }

    private void processLocalVariable(DeclarationExpression de, ClassCodeVisitorSupport visitor) {
        if (!this.isEnabled(de)) {
            return;
        }
        if (de.getRightExpression() instanceof ClosureExpression) {
            visitor.visitDeclarationExpression(de);
        }
    }

    private void processField(FieldNode fNode, ClassCodeVisitorSupport visitor) {
        if (!this.isEnabled(fNode)) {
            return;
        }
        if (fNode.hasInitialExpression() && fNode.getInitialExpression() instanceof ClosureExpression) {
            visitor.visitField(fNode);
        }
    }

    private void processConstructorOrMethod(MethodNode mNode, ClassCodeVisitorSupport visitor) {
        Parameter[] origParams;
        if (!this.isEnabled(mNode)) {
            return;
        }
        if (mNode.isSynthetic()) {
            return;
        }
        for (Parameter p : origParams = mNode.getParameters()) {
            p.setModifiers(p.getModifiers() | 0x10);
        }
        visitor.visitMethod(mNode);
    }

    private boolean isEnabled(AnnotatedNode node) {
        if (node == null) {
            return false;
        }
        List<AnnotationNode> annotations = node.getAnnotations(MY_TYPE);
        if (annotations != null) {
            for (AnnotationNode anno : annotations) {
                if (!this.memberHasValue(anno, "enabled", false)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean hasNoExplicitAutoFinal(AnnotatedNode node) {
        return node.getAnnotations(MY_TYPE).isEmpty();
    }
}

