/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.testing.assertj.AssertUtil;
import io.opentelemetry.sdk.testing.assertj.AttributeAssertion;
import io.opentelemetry.sdk.testing.assertj.OpenTelemetryAssertions;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;

public abstract class AbstractPointAssert<PointAssertT extends AbstractPointAssert<PointAssertT, PointT>, PointT extends PointData>
extends AbstractAssert<PointAssertT, PointT> {
    AbstractPointAssert(@Nullable PointT actual, Class<PointAssertT> assertClass) {
        super(actual, assertClass);
    }

    public final PointAssertT hasStartEpochNanos(long expected) {
        this.isNotNull();
        ((AbstractLongAssert)Assertions.assertThat((long)((PointData)this.actual).getStartEpochNanos()).as("startEpochNanos", new Object[0])).isEqualTo(expected);
        return (PointAssertT)((Object)((AbstractPointAssert)this.myself));
    }

    public final PointAssertT hasEpochNanos(long expected) {
        this.isNotNull();
        ((AbstractLongAssert)Assertions.assertThat((long)((PointData)this.actual).getEpochNanos()).as("epochNanos", new Object[0])).isEqualTo(expected);
        return (PointAssertT)((Object)((AbstractPointAssert)this.myself));
    }

    public final <T> PointAssertT hasAttribute(AttributeKey<T> key, T value) {
        return this.hasAttribute(OpenTelemetryAssertions.equalTo(key, value));
    }

    public final PointAssertT hasAttribute(AttributeAssertion attributeAssertion) {
        this.isNotNull();
        Set<AttributeKey<?>> actualKeys = ((PointData)this.actual).getAttributes().asMap().keySet();
        AttributeKey<?> key = attributeAssertion.getKey();
        ((AbstractCollectionAssert)Assertions.assertThat(actualKeys).as("attribute keys", new Object[0])).contains((Object[])new AttributeKey[]{key});
        Object value = ((PointData)this.actual).getAttributes().get(key);
        AbstractAssert<?, ?> assertion = AttributeAssertion.attributeValueAssertion(key, value);
        attributeAssertion.getAssertion().accept(assertion);
        return (PointAssertT)((Object)((AbstractPointAssert)this.myself));
    }

    public final PointAssertT hasAttributes(Attributes attributes) {
        this.isNotNull();
        if (!AssertUtil.attributesAreEqual(((PointData)this.actual).getAttributes(), attributes)) {
            this.failWithActualExpectedAndMessage(((PointData)this.actual).getAttributes(), attributes, "Expected point to have attributes <%s> but was <%s>", new Object[]{attributes, ((PointData)this.actual).getAttributes()});
        }
        return (PointAssertT)((Object)((AbstractPointAssert)this.myself));
    }

    @SafeVarargs
    public final PointAssertT hasAttributes(Map.Entry<? extends AttributeKey<?>, ?> ... entries) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        for (Map.Entry<AttributeKey<?>, ?> entry : entries) {
            attributesBuilder.put(entry.getKey(), entry.getValue());
        }
        Attributes attributes = attributesBuilder.build();
        return this.hasAttributes(attributes);
    }

    public final PointAssertT hasAttributesSatisfying(AttributeAssertion ... assertions) {
        return this.hasAttributesSatisfying(Arrays.asList(assertions));
    }

    public final PointAssertT hasAttributesSatisfying(Iterable<AttributeAssertion> assertions) {
        AssertUtil.assertAttributes(((PointData)this.actual).getAttributes(), assertions);
        return (PointAssertT)((Object)((AbstractPointAssert)this.myself));
    }
}

