/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs;

import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.internal.ComponentRegistry;
import io.opentelemetry.sdk.logs.LogEmitter;
import io.opentelemetry.sdk.logs.LogEmitterBuilder;
import io.opentelemetry.sdk.logs.LogEmitterSharedState;
import io.opentelemetry.sdk.logs.LogLimits;
import io.opentelemetry.sdk.logs.LogProcessor;
import io.opentelemetry.sdk.logs.SdkLogEmitter;
import io.opentelemetry.sdk.logs.SdkLogEmitterBuilder;
import io.opentelemetry.sdk.logs.SdkLogEmitterProviderBuilder;
import io.opentelemetry.sdk.resources.Resource;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SdkLogEmitterProvider
implements Closeable {
    static final String DEFAULT_EMITTER_NAME = "unknown";
    private static final Logger LOGGER = Logger.getLogger(SdkLogEmitterProvider.class.getName());
    private final LogEmitterSharedState sharedState;
    private final ComponentRegistry<SdkLogEmitter> logEmitterComponentRegistry;

    public static SdkLogEmitterProviderBuilder builder() {
        return new SdkLogEmitterProviderBuilder();
    }

    SdkLogEmitterProvider(Resource resource, Supplier<LogLimits> logLimitsSupplier, List<LogProcessor> processors, Clock clock) {
        this.sharedState = new LogEmitterSharedState(resource, logLimitsSupplier, processors, clock);
        this.logEmitterComponentRegistry = new ComponentRegistry<SdkLogEmitter>(instrumentationScopeInfo -> new SdkLogEmitter(this.sharedState, (InstrumentationScopeInfo)instrumentationScopeInfo));
    }

    public LogEmitter get(String instrumentationScopeName) {
        return this.logEmitterBuilder(instrumentationScopeName).build();
    }

    public LogEmitterBuilder logEmitterBuilder(String instrumentationScopeName) {
        if (instrumentationScopeName == null || instrumentationScopeName.isEmpty()) {
            LOGGER.fine("LogEmitter requested without instrumentation scope name.");
            instrumentationScopeName = DEFAULT_EMITTER_NAME;
        }
        return new SdkLogEmitterBuilder(this.logEmitterComponentRegistry, instrumentationScopeName);
    }

    public CompletableResultCode forceFlush() {
        return this.sharedState.getLogProcessor().forceFlush();
    }

    public CompletableResultCode shutdown() {
        if (this.sharedState.hasBeenShutdown()) {
            LOGGER.log(Level.WARNING, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.sharedState.shutdown();
    }

    @Override
    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

