/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.logs.LogProcessor;
import io.opentelemetry.sdk.logs.data.LogData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

final class MultiLogProcessor
implements LogProcessor {
    private final List<LogProcessor> logProcessors;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    static LogProcessor create(List<LogProcessor> logProcessorsList) {
        return new MultiLogProcessor(new ArrayList<LogProcessor>((Collection)Objects.requireNonNull(logProcessorsList, "logProcessorsList")));
    }

    @Override
    public void emit(LogData logData) {
        for (LogProcessor logProcessor : this.logProcessors) {
            logProcessor.emit(logData);
        }
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>(this.logProcessors.size());
        for (LogProcessor logProcessor : this.logProcessors) {
            results.add(logProcessor.shutdown());
        }
        return CompletableResultCode.ofAll(results);
    }

    @Override
    public CompletableResultCode forceFlush() {
        ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>(this.logProcessors.size());
        for (LogProcessor logProcessor : this.logProcessors) {
            results.add(logProcessor.forceFlush());
        }
        return CompletableResultCode.ofAll(results);
    }

    private MultiLogProcessor(List<LogProcessor> logProcessorsList) {
        this.logProcessors = logProcessorsList;
    }
}

