/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.internal;

import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class ComponentRegistry<V> {
    private final ConcurrentMap<InstrumentationScopeInfo, V> registry = new ConcurrentHashMap<InstrumentationScopeInfo, V>();
    private final Function<InstrumentationScopeInfo, V> factory;

    public ComponentRegistry(Function<InstrumentationScopeInfo, V> factory2) {
        this.factory = factory2;
    }

    public V get(String instrumentationScopeName) {
        return this.get(instrumentationScopeName, null);
    }

    public V get(String instrumentationScopeName, @Nullable String instrumentationScopeVersion) {
        return this.get(instrumentationScopeName, instrumentationScopeVersion, null);
    }

    public V get(String instrumentationScopeName, @Nullable String instrumentationScopeVersion, @Nullable String schemaUrl) {
        InstrumentationScopeInfo instrumentationScopeInfo = InstrumentationScopeInfo.create(instrumentationScopeName, instrumentationScopeVersion, schemaUrl);
        Object component = this.registry.get(instrumentationScopeInfo);
        if (component != null) {
            return component;
        }
        V newComponent = this.factory.apply(instrumentationScopeInfo);
        V oldComponent = this.registry.putIfAbsent(instrumentationScopeInfo, newComponent);
        return oldComponent != null ? oldComponent : newComponent;
    }

    public Collection<V> getComponents() {
        return Collections.unmodifiableCollection(new ArrayList(this.registry.values()));
    }
}

