/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.internal;

import java.util.AbstractList;

public class ArrayQueue
extends AbstractList {
    private int capacity;
    private Object[] queue;
    private int head;
    private int tail;

    public ArrayQueue(int capacity) {
        this.capacity = capacity + 1;
        this.queue = new Object[capacity + 1];
        this.head = 0;
        this.tail = 0;
    }

    public void resize(int newcapacity) {
        int size = this.size();
        if (newcapacity < size) {
            throw new IndexOutOfBoundsException("Resizing would lose data");
        }
        if (++newcapacity == this.capacity) {
            return;
        }
        Object[] newqueue = new Object[newcapacity];
        for (int i = 0; i < size; ++i) {
            newqueue[i] = this.get(i);
        }
        this.capacity = newcapacity;
        this.queue = newqueue;
        this.head = 0;
        this.tail = size;
    }

    @Override
    public boolean add(Object o) {
        this.queue[this.tail] = o;
        int newtail = (this.tail + 1) % this.capacity;
        if (newtail == this.head) {
            throw new IndexOutOfBoundsException("Queue full");
        }
        this.tail = newtail;
        return true;
    }

    @Override
    public Object remove(int i) {
        if (i != 0) {
            throw new IllegalArgumentException("Can only remove head of queue");
        }
        if (this.head == this.tail) {
            throw new IndexOutOfBoundsException("Queue empty");
        }
        Object removed = this.queue[this.head];
        this.queue[this.head] = null;
        this.head = (this.head + 1) % this.capacity;
        return removed;
    }

    @Override
    public Object get(int i) {
        int size = this.size();
        if (i < 0 || i >= size) {
            String msg = "Index " + i + ", queue size " + size;
            throw new IndexOutOfBoundsException(msg);
        }
        int index = (this.head + i) % this.capacity;
        return this.queue[index];
    }

    @Override
    public int size() {
        int diff = this.tail - this.head;
        if (diff < 0) {
            diff += this.capacity;
        }
        return diff;
    }
}

