/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.testing.assertj.AbstractPointDataAssert;
import java.util.Arrays;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;

public class HistogramPointDataAssert
extends AbstractPointDataAssert<HistogramPointDataAssert, HistogramPointData> {
    protected HistogramPointDataAssert(HistogramPointData actual) {
        super(actual, HistogramPointDataAssert.class);
    }

    public HistogramPointDataAssert hasSum(double expected) {
        this.isNotNull();
        ((AbstractDoubleAssert)Assertions.assertThat((double)((HistogramPointData)this.actual).getSum()).as("sum", new Object[0])).isEqualTo(expected);
        return this;
    }

    public HistogramPointDataAssert hasSumGreaterThan(double boundary) {
        this.isNotNull();
        ((AbstractDoubleAssert)Assertions.assertThat((double)((HistogramPointData)this.actual).getSum()).as("sum", new Object[0])).isGreaterThan(boundary);
        return this;
    }

    public HistogramPointDataAssert hasMin(double expected) {
        this.isNotNull();
        Assertions.assertThat((boolean)((HistogramPointData)this.actual).hasMin()).isTrue();
        ((AbstractDoubleAssert)Assertions.assertThat((double)((HistogramPointData)this.actual).getMin()).as("min", new Object[0])).isEqualTo(expected);
        return this;
    }

    public HistogramPointDataAssert hasMax(double expected) {
        this.isNotNull();
        Assertions.assertThat((boolean)((HistogramPointData)this.actual).hasMax()).isTrue();
        ((AbstractDoubleAssert)Assertions.assertThat((double)((HistogramPointData)this.actual).getMax()).as("max", new Object[0])).isEqualTo(expected);
        return this;
    }

    public HistogramPointDataAssert hasCount(long expected) {
        this.isNotNull();
        ((AbstractLongAssert)Assertions.assertThat((long)((HistogramPointData)this.actual).getCount()).as("count", new Object[0])).isEqualTo(expected);
        return this;
    }

    public HistogramPointDataAssert hasBucketBoundaries(double ... boundaries) {
        this.isNotNull();
        Object[] bigBoundaries = (Double[])Arrays.stream(boundaries).boxed().toArray(Double[]::new);
        ((ListAssert)Assertions.assertThat(((HistogramPointData)this.actual).getBoundaries()).as("boundaries", new Object[0])).containsExactly(bigBoundaries);
        return this;
    }

    public HistogramPointDataAssert hasBucketCounts(long ... counts) {
        this.isNotNull();
        Object[] bigCounts = (Long[])Arrays.stream(counts).boxed().toArray(Long[]::new);
        ((ListAssert)Assertions.assertThat(((HistogramPointData)this.actual).getCounts()).as("bucketCounts", new Object[0])).containsExactly(bigCounts);
        return this;
    }
}

