/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.internal.data.exponentialhistogram.ExponentialHistogramData;
import io.opentelemetry.sdk.metrics.internal.data.exponentialhistogram.ExponentialHistogramPointData;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIterableAssert;
import org.assertj.core.api.Assertions;

public class ExponentialHistogramAssert
extends AbstractAssert<ExponentialHistogramAssert, ExponentialHistogramData> {
    protected ExponentialHistogramAssert(ExponentialHistogramData actual) {
        super((Object)actual, ExponentialHistogramAssert.class);
    }

    public ExponentialHistogramAssert isCumulative() {
        this.isNotNull();
        if (((ExponentialHistogramData)this.actual).getAggregationTemporality() != AggregationTemporality.CUMULATIVE) {
            this.failWithActualExpectedAndMessage(this.actual, "aggregationTemporality: CUMULATIVE", "Expected Histogram to have cumulative aggregation but found <%s>", new Object[]{((ExponentialHistogramData)this.actual).getAggregationTemporality()});
        }
        return this;
    }

    public ExponentialHistogramAssert isDelta() {
        this.isNotNull();
        if (((ExponentialHistogramData)this.actual).getAggregationTemporality() != AggregationTemporality.DELTA) {
            this.failWithActualExpectedAndMessage(this.actual, "aggregationTemporality: DELTA", "Expected Histogram to have cumulative aggregation but found <%s>", new Object[]{AggregationTemporality.DELTA, ((ExponentialHistogramData)this.actual).getAggregationTemporality()});
        }
        return this;
    }

    public AbstractIterableAssert<?, ? extends Iterable<? extends ExponentialHistogramPointData>, ExponentialHistogramPointData, ?> points() {
        this.isNotNull();
        return Assertions.assertThat(((ExponentialHistogramData)this.actual).getPoints());
    }
}

