/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.internal.ThrowableUtil;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.AsynchronousMetricStorage;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CallbackRegistration<T> {
    private static final Logger logger = Logger.getLogger(CallbackRegistration.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final InstrumentDescriptor instrumentDescriptor;
    private final Consumer<T> callback;
    private final T measurement;
    private final boolean noStoragesRegistered;

    private CallbackRegistration(InstrumentDescriptor instrumentDescriptor, Consumer<T> callback, T measurement, List<AsynchronousMetricStorage<?>> storages) {
        this.instrumentDescriptor = instrumentDescriptor;
        this.callback = callback;
        this.measurement = measurement;
        this.noStoragesRegistered = storages.size() == 0;
    }

    public static CallbackRegistration<ObservableDoubleMeasurement> createDouble(InstrumentDescriptor instrumentDescriptor, Consumer<ObservableDoubleMeasurement> callback, List<AsynchronousMetricStorage<?>> asyncMetricStorages) {
        ObservableDoubleMeasurementImpl measurement = new ObservableDoubleMeasurementImpl(asyncMetricStorages);
        return new CallbackRegistration<ObservableDoubleMeasurement>(instrumentDescriptor, callback, measurement, asyncMetricStorages);
    }

    public static CallbackRegistration<ObservableLongMeasurement> createLong(InstrumentDescriptor instrumentDescriptor, Consumer<ObservableLongMeasurement> callback, List<AsynchronousMetricStorage<?>> asyncMetricStorages) {
        ObservableLongMeasurementImpl measurement = new ObservableLongMeasurementImpl(asyncMetricStorages);
        return new CallbackRegistration<ObservableLongMeasurement>(instrumentDescriptor, callback, measurement, asyncMetricStorages);
    }

    public InstrumentDescriptor getInstrumentDescriptor() {
        return this.instrumentDescriptor;
    }

    void invokeCallback() {
        if (this.noStoragesRegistered) {
            return;
        }
        try {
            this.callback.accept(this.measurement);
        }
        catch (Throwable e) {
            ThrowableUtil.propagateIfFatal(e);
            this.throttlingLogger.log(Level.WARNING, "An exception occurred invoking callback for instrument " + this.instrumentDescriptor.getName() + ".", e);
        }
    }

    private static class ObservableDoubleMeasurementImpl
    implements ObservableDoubleMeasurement {
        private final List<AsynchronousMetricStorage<?>> asyncMetricStorages;

        private ObservableDoubleMeasurementImpl(List<AsynchronousMetricStorage<?>> asyncMetricStorages) {
            this.asyncMetricStorages = asyncMetricStorages;
        }

        @Override
        public void record(double value) {
            this.record(value, Attributes.empty());
        }

        @Override
        public void record(double value, Attributes attributes) {
            for (AsynchronousMetricStorage<?> asyncMetricStorage : this.asyncMetricStorages) {
                asyncMetricStorage.recordDouble(value, attributes);
            }
        }
    }

    private static class ObservableLongMeasurementImpl
    implements ObservableLongMeasurement {
        private final List<AsynchronousMetricStorage<?>> asyncMetricStorages;

        private ObservableLongMeasurementImpl(List<AsynchronousMetricStorage<?>> asyncMetricStorages) {
            this.asyncMetricStorages = asyncMetricStorages;
        }

        @Override
        public void record(long value) {
            this.record(value, Attributes.empty());
        }

        @Override
        public void record(long value, Attributes attributes) {
            for (AsynchronousMetricStorage<?> asyncMetricStorage : this.asyncMetricStorages) {
                asyncMetricStorage.recordLong(value, attributes);
            }
        }
    }
}

