/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.data;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.internal.PrimitiveLongList;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.metrics.internal.data.AutoValue_ImmutableHistogramPointData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class ImmutableHistogramPointData
implements HistogramPointData {
    public static ImmutableHistogramPointData create(long startEpochNanos, long epochNanos, Attributes attributes, double sum, @Nullable Double min2, @Nullable Double max, List<Double> boundaries, List<Long> counts) {
        return ImmutableHistogramPointData.create(startEpochNanos, epochNanos, attributes, sum, min2, max, boundaries, counts, Collections.emptyList());
    }

    public static ImmutableHistogramPointData create(long startEpochNanos, long epochNanos, Attributes attributes, double sum, @Nullable Double min2, @Nullable Double max, List<Double> boundaries, List<Long> counts, List<ExemplarData> exemplars) {
        if (counts.size() != boundaries.size() + 1) {
            throw new IllegalArgumentException("invalid counts: size should be " + (boundaries.size() + 1) + " instead of " + counts.size());
        }
        if (!ImmutableHistogramPointData.isStrictlyIncreasing(boundaries)) {
            throw new IllegalArgumentException("invalid boundaries: " + boundaries);
        }
        if (!boundaries.isEmpty() && (boundaries.get(0).isInfinite() || boundaries.get(boundaries.size() - 1).isInfinite())) {
            throw new IllegalArgumentException("invalid boundaries: contains explicit +/-Inf");
        }
        long totalCount = 0L;
        for (long c : PrimitiveLongList.toArray(counts)) {
            totalCount += c;
        }
        return new AutoValue_ImmutableHistogramPointData(startEpochNanos, epochNanos, attributes, exemplars, sum, totalCount, min2 != null, min2 != null ? min2 : -1.0, max != null, max != null ? max : -1.0, Collections.unmodifiableList(new ArrayList<Double>(boundaries)), Collections.unmodifiableList(new ArrayList<Long>(counts)));
    }

    ImmutableHistogramPointData() {
    }

    private static boolean isStrictlyIncreasing(List<Double> xs) {
        for (int i = 0; i < xs.size() - 1; ++i) {
            if (xs.get(i).compareTo(xs.get(i + 1)) < 0) continue;
            return false;
        }
        return true;
    }
}

