/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ResourceProvider;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.function.BiFunction;

final class ResourceConfiguration {
    static final String ATTRIBUTE_PROPERTY = "otel.resource.attributes";
    static final String SERVICE_NAME_PROPERTY = "otel.service.name";
    static final String DISABLED_ATTRIBUTE_KEYS = "otel.experimental.resource.disabled.keys";

    static Resource configureResource(ConfigProperties config, ClassLoader serviceClassLoader, BiFunction<? super Resource, ConfigProperties, ? extends Resource> resourceCustomizer) {
        Resource result = Resource.getDefault();
        HashSet<String> enabledProviders = new HashSet<String>(config.getList("otel.java.enabled.resource.providers"));
        HashSet<String> disabledProviders = new HashSet<String>(config.getList("otel.java.disabled.resource.providers"));
        for (ResourceProvider resourceProvider : ServiceLoader.load(ResourceProvider.class, serviceClassLoader)) {
            if (!enabledProviders.isEmpty() && !enabledProviders.contains(resourceProvider.getClass().getName()) || disabledProviders.contains(resourceProvider.getClass().getName())) continue;
            result = result.merge(resourceProvider.createResource(config));
        }
        result = result.merge(ResourceConfiguration.createEnvironmentResource(config));
        result = ResourceConfiguration.filterAttributes(result, config);
        return resourceCustomizer.apply(result, config);
    }

    private static Resource createEnvironmentResource(ConfigProperties config) {
        return Resource.create(ResourceConfiguration.getAttributes(config), "https://opentelemetry.io/schemas/1.9.0");
    }

    static Attributes getAttributes(ConfigProperties configProperties) {
        AttributesBuilder resourceAttributes = Attributes.builder();
        configProperties.getMap(ATTRIBUTE_PROPERTY).forEach(resourceAttributes::put);
        String serviceName = configProperties.getString(SERVICE_NAME_PROPERTY);
        if (serviceName != null) {
            resourceAttributes.put(ResourceAttributes.SERVICE_NAME, serviceName);
        }
        return resourceAttributes.build();
    }

    static Resource filterAttributes(Resource resource, ConfigProperties configProperties) {
        HashSet<String> disabledKeys = new HashSet<String>(configProperties.getList(DISABLED_ATTRIBUTE_KEYS));
        ResourceBuilder builder = resource.toBuilder().removeIf(attributeKey -> disabledKeys.contains(attributeKey.getKey()));
        if (resource.getSchemaUrl() != null) {
            builder.setSchemaUrl(resource.getSchemaUrl());
        }
        return builder.build();
    }

    private ResourceConfiguration() {
    }
}

