/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.metrics;

import io.opentelemetry.exporter.internal.grpc.GrpcExporter;
import io.opentelemetry.exporter.internal.otlp.metrics.MetricsRequestMarshaler;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OtlpGrpcMetricExporter
implements MetricExporter {
    private final GrpcExporter<MetricsRequestMarshaler> delegate;
    private final Function<InstrumentType, AggregationTemporality> aggregationTemporalityFunction;

    public static OtlpGrpcMetricExporter getDefault() {
        return OtlpGrpcMetricExporter.builder().build();
    }

    public static OtlpGrpcMetricExporterBuilder builder() {
        return new OtlpGrpcMetricExporterBuilder();
    }

    OtlpGrpcMetricExporter(GrpcExporter<MetricsRequestMarshaler> delegate, Function<InstrumentType, AggregationTemporality> aggregationTemporalityFunction) {
        this.delegate = delegate;
        this.aggregationTemporalityFunction = aggregationTemporalityFunction;
    }

    @Override
    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.aggregationTemporalityFunction.apply(instrumentType);
    }

    @Override
    public CompletableResultCode export(Collection<MetricData> metrics) {
        MetricsRequestMarshaler request = MetricsRequestMarshaler.create(metrics);
        return this.delegate.export(request, metrics.size());
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }
}

