/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.exporter;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.MetricReaderFactory;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;

public class InMemoryMetricReader
implements MetricReader,
MetricReaderFactory {
    private final AggregationTemporality preferred;
    @Nullable
    private volatile MetricProducer metricProducer;

    public static InMemoryMetricReader create() {
        return new InMemoryMetricReader(AggregationTemporality.CUMULATIVE);
    }

    public static InMemoryMetricReader createDelta() {
        return new InMemoryMetricReader(AggregationTemporality.DELTA);
    }

    private InMemoryMetricReader(AggregationTemporality preferred) {
        this.preferred = preferred;
    }

    public Collection<MetricData> collectAllMetrics() {
        MetricProducer metricProducer = this.metricProducer;
        if (metricProducer != null) {
            return metricProducer.collectAllMetrics();
        }
        return Collections.emptyList();
    }

    @Override
    public AggregationTemporality getPreferredTemporality() {
        return this.preferred;
    }

    @Override
    public CompletableResultCode flush() {
        MetricProducer metricProducer = this.metricProducer;
        if (metricProducer != null) {
            metricProducer.collectAllMetrics();
        }
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        this.metricProducer = null;
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public MetricReader apply(MetricProducer producer) {
        this.metricProducer = producer;
        return this;
    }
}

