/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.metrics.data.SumData;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIterableAssert;
import org.assertj.core.api.Assertions;

public class SumDataAssert<T extends PointData>
extends AbstractAssert<SumDataAssert<T>, SumData<T>> {
    protected SumDataAssert(SumData<T> actual) {
        super(actual, SumDataAssert.class);
    }

    public SumDataAssert<T> isMonotonic() {
        this.isNotNull();
        if (!((SumData)this.actual).isMonotonic()) {
            this.failWithActualExpectedAndMessage(this.actual, "monotonic: true", "Expected Sum to be monotonic", new Object[]{true, ((SumData)this.actual).isMonotonic()});
        }
        return (SumDataAssert)this.myself;
    }

    public SumDataAssert<T> isNotMonotonic() {
        this.isNotNull();
        if (((SumData)this.actual).isMonotonic()) {
            this.failWithActualExpectedAndMessage(this.actual, "monotonic: fail", "Expected Sum to be non-monotonic, found: %s", new Object[]{((SumData)this.actual).isMonotonic()});
        }
        return (SumDataAssert)this.myself;
    }

    public SumDataAssert<T> isCumulative() {
        this.isNotNull();
        if (((SumData)this.actual).getAggregationTemporality() != AggregationTemporality.CUMULATIVE) {
            this.failWithActualExpectedAndMessage(this.actual, "aggregationTemporality: CUMULATIVE", "Expected Sum to have cumulative aggregation but found <%s>", new Object[]{((SumData)this.actual).getAggregationTemporality()});
        }
        return (SumDataAssert)this.myself;
    }

    public SumDataAssert<T> isDelta() {
        this.isNotNull();
        if (((SumData)this.actual).getAggregationTemporality() != AggregationTemporality.DELTA) {
            this.failWithActualExpectedAndMessage(this.actual, "aggregationTemporality: DELTA", "Expected Sum to have delta aggregation but found <%s>", new Object[]{((SumData)this.actual).getAggregationTemporality()});
        }
        return (SumDataAssert)this.myself;
    }

    public AbstractIterableAssert<?, ? extends Iterable<? extends T>, T, ?> points() {
        this.isNotNull();
        return Assertions.assertThat(((SumData)this.actual).getPoints());
    }
}

