/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.testing.assertj.AttributeAssertion;
import io.opentelemetry.sdk.testing.assertj.AttributesAssert;
import io.opentelemetry.sdk.testing.assertj.EventDataAssert;
import io.opentelemetry.sdk.testing.assertj.SpanDataAssert;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;

public final class OpenTelemetryAssertions
extends Assertions {
    public static AttributesAssert assertThat(@Nullable Attributes attributes) {
        return new AttributesAssert(attributes);
    }

    public static SpanDataAssert assertThat(@Nullable SpanData spanData) {
        return new SpanDataAssert(spanData);
    }

    public static EventDataAssert assertThat(@Nullable EventData eventData) {
        return new EventDataAssert(eventData);
    }

    public static Map.Entry<AttributeKey<String>, String> attributeEntry(String key, String value) {
        return new AbstractMap.SimpleImmutableEntry<AttributeKey<String>, String>(AttributeKey.stringKey(key), value);
    }

    public static Map.Entry<AttributeKey<Boolean>, Boolean> attributeEntry(String key, boolean value) {
        return new AbstractMap.SimpleImmutableEntry<AttributeKey<Boolean>, Boolean>(AttributeKey.booleanKey(key), value);
    }

    public static Map.Entry<AttributeKey<Long>, Long> attributeEntry(String key, long value) {
        return new AbstractMap.SimpleImmutableEntry<AttributeKey<Long>, Long>(AttributeKey.longKey(key), value);
    }

    public static Map.Entry<AttributeKey<Double>, Double> attributeEntry(String key, double value) {
        return new AbstractMap.SimpleImmutableEntry<AttributeKey<Double>, Double>(AttributeKey.doubleKey(key), value);
    }

    public static Map.Entry<AttributeKey<List<String>>, List<String>> attributeEntry(String key, String ... value) {
        return new AbstractMap.SimpleImmutableEntry<AttributeKey<List<String>>, List<String>>(AttributeKey.stringArrayKey(key), Arrays.asList(value));
    }

    public static Map.Entry<AttributeKey<List<Boolean>>, List<Boolean>> attributeEntry(String key, boolean ... value) {
        return new AbstractMap.SimpleImmutableEntry<AttributeKey<List<Boolean>>, List<Boolean>>(AttributeKey.booleanArrayKey(key), OpenTelemetryAssertions.toList(value));
    }

    public static Map.Entry<AttributeKey<List<Long>>, List<Long>> attributeEntry(String key, long ... value) {
        return new AbstractMap.SimpleImmutableEntry<AttributeKey<List<Long>>, List<Long>>(AttributeKey.longArrayKey(key), Arrays.stream(value).boxed().collect(Collectors.toList()));
    }

    public static Map.Entry<AttributeKey<List<Double>>, List<Double>> attributeEntry(String key, double ... value) {
        return new AbstractMap.SimpleImmutableEntry<AttributeKey<List<Double>>, List<Double>>(AttributeKey.doubleArrayKey(key), Arrays.stream(value).boxed().collect(Collectors.toList()));
    }

    public static AttributeAssertion satisfies(AttributeKey<String> key, StringAssertConsumer assertion) {
        return AttributeAssertion.create(key, assertion);
    }

    public static AttributeAssertion satisfies(AttributeKey<Boolean> key, BooleanAssertConsumer assertion) {
        return AttributeAssertion.create(key, assertion);
    }

    public static AttributeAssertion satisfies(AttributeKey<Long> key, LongAssertConsumer assertion) {
        return AttributeAssertion.create(key, assertion);
    }

    public static AttributeAssertion satisfies(AttributeKey<Double> key, DoubleAssertConsumer assertion) {
        return AttributeAssertion.create(key, assertion);
    }

    public static AttributeAssertion satisfies(AttributeKey<List<String>> key, StringListAssertConsumer assertion) {
        return AttributeAssertion.create(key, assertion);
    }

    public static AttributeAssertion satisfies(AttributeKey<List<Boolean>> key, BooleanListAssertConsumer assertion) {
        return AttributeAssertion.create(key, assertion);
    }

    public static AttributeAssertion satisfies(AttributeKey<List<Long>> key, LongListAssertConsumer assertion) {
        return AttributeAssertion.create(key, assertion);
    }

    public static AttributeAssertion satisfies(AttributeKey<List<Double>> key, DoubleListAssertConsumer assertion) {
        return AttributeAssertion.create(key, assertion);
    }

    public static <T> AttributeAssertion equalTo(AttributeKey<T> key, T value) {
        return AttributeAssertion.create(key, val -> val.isEqualTo(value));
    }

    private static List<Boolean> toList(boolean ... values2) {
        Boolean[] boxed = new Boolean[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            boxed[i] = values2[i];
        }
        return Arrays.asList(boxed);
    }

    private OpenTelemetryAssertions() {
    }

    public static interface DoubleListAssertConsumer
    extends Consumer<ListAssert<Double>> {
    }

    public static interface LongListAssertConsumer
    extends Consumer<ListAssert<Long>> {
    }

    public static interface BooleanListAssertConsumer
    extends Consumer<ListAssert<Boolean>> {
    }

    public static interface StringListAssertConsumer
    extends Consumer<ListAssert<String>> {
    }

    public static interface DoubleAssertConsumer
    extends Consumer<AbstractDoubleAssert<?>> {
    }

    public static interface LongAssertConsumer
    extends Consumer<AbstractLongAssert<?>> {
    }

    public static interface BooleanAssertConsumer
    extends Consumer<AbstractBooleanAssert<?>> {
    }

    public static interface StringAssertConsumer
    extends Consumer<AbstractStringAssert<?>> {
    }
}

