/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.metrics.internal.data.exponentialhistogram.ExponentialHistogramData;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.testing.assertj.ExponentialHistogramAssert;
import io.opentelemetry.sdk.testing.assertj.GaugeAssert;
import io.opentelemetry.sdk.testing.assertj.HistogramAssert;
import io.opentelemetry.sdk.testing.assertj.SumDataAssert;
import io.opentelemetry.sdk.testing.assertj.SummaryDataAssert;
import org.assertj.core.api.AbstractAssert;

public class MetricDataAssert
extends AbstractAssert<MetricDataAssert, MetricData> {
    protected MetricDataAssert(MetricData actual) {
        super((Object)actual, MetricDataAssert.class);
    }

    public MetricDataAssert hasResource(Resource resource) {
        this.isNotNull();
        if (!((MetricData)this.actual).getResource().equals(resource)) {
            this.failWithActualExpectedAndMessage(this.actual, "resource: " + resource, "Expected MetricData to have resource <%s> but found <%s>", new Object[]{resource, ((MetricData)this.actual).getResource()});
        }
        return this;
    }

    public MetricDataAssert hasInstrumentationLibrary(InstrumentationLibraryInfo instrumentationLibrary) {
        this.isNotNull();
        if (!((MetricData)this.actual).getInstrumentationLibraryInfo().equals(instrumentationLibrary)) {
            this.failWithActualExpectedAndMessage(this.actual, "instrumentation library: " + instrumentationLibrary, "Expected MetricData to have resource <%s> but found <%s>", new Object[]{instrumentationLibrary, ((MetricData)this.actual).getInstrumentationLibraryInfo()});
        }
        return this;
    }

    public MetricDataAssert hasName(String name) {
        this.isNotNull();
        if (!((MetricData)this.actual).getName().equals(name)) {
            this.failWithActualExpectedAndMessage(this.actual, "name: " + name, "Expected MetricData to have name <%s> but found <%s>", new Object[]{name, ((MetricData)this.actual).getName()});
        }
        return this;
    }

    public MetricDataAssert hasDescription(String description) {
        this.isNotNull();
        if (!((MetricData)this.actual).getDescription().equals(description)) {
            this.failWithActualExpectedAndMessage(this.actual, "description: " + description, "Expected MetricData to have description <%s> but found <%s>", new Object[]{description, ((MetricData)this.actual).getDescription()});
        }
        return this;
    }

    public MetricDataAssert hasUnit(String unit) {
        this.isNotNull();
        if (!((MetricData)this.actual).getUnit().equals(unit)) {
            this.failWithActualExpectedAndMessage(this.actual, "unit: " + unit, "Expected MetricData to have unit <%s> but found <%s>", new Object[]{unit, ((MetricData)this.actual).getUnit()});
        }
        return this;
    }

    public HistogramAssert hasDoubleHistogram() {
        this.isNotNull();
        if (((MetricData)this.actual).getType() != MetricDataType.HISTOGRAM) {
            this.failWithActualExpectedAndMessage(this.actual, "type: HISTOGRAM", "Expected MetricData to have type <%s> but found <%s>", new Object[]{MetricDataType.HISTOGRAM, ((MetricData)this.actual).getType()});
        }
        return new HistogramAssert(((MetricData)this.actual).getHistogramData());
    }

    public ExponentialHistogramAssert hasExponentialHistogram() {
        this.isNotNull();
        if (((MetricData)this.actual).getType() != MetricDataType.EXPONENTIAL_HISTOGRAM) {
            this.failWithActualExpectedAndMessage(this.actual, "type: EXPONENTIAL_HISTOGRAM", "Expected MetricData to have type <%s> but found <%s>", new Object[]{MetricDataType.EXPONENTIAL_HISTOGRAM, ((MetricData)this.actual).getType()});
        }
        return new ExponentialHistogramAssert(ExponentialHistogramData.fromMetricData((MetricData)this.actual));
    }

    public GaugeAssert<DoublePointData> hasDoubleGauge() {
        this.isNotNull();
        if (((MetricData)this.actual).getType() != MetricDataType.DOUBLE_GAUGE) {
            this.failWithActualExpectedAndMessage(this.actual, "type: DOUBLE_GAUGE", "Expected MetricData to have type <%s> but found <%s>", new Object[]{MetricDataType.DOUBLE_GAUGE, ((MetricData)this.actual).getType()});
        }
        return new GaugeAssert<DoublePointData>(((MetricData)this.actual).getDoubleGaugeData());
    }

    public SumDataAssert<DoublePointData> hasDoubleSum() {
        this.isNotNull();
        if (((MetricData)this.actual).getType() != MetricDataType.DOUBLE_SUM) {
            this.failWithActualExpectedAndMessage(this.actual, "type: DOUBLE_SUM", "Expected MetricData to have type <%s> but found <%s>", new Object[]{MetricDataType.DOUBLE_SUM, ((MetricData)this.actual).getType()});
        }
        return new SumDataAssert<DoublePointData>(((MetricData)this.actual).getDoubleSumData());
    }

    public GaugeAssert<LongPointData> hasLongGauge() {
        this.isNotNull();
        if (((MetricData)this.actual).getType() != MetricDataType.LONG_GAUGE) {
            this.failWithActualExpectedAndMessage(this.actual, "type: LONG_GAUGE", "Expected MetricData to have type <%s> but found <%s>", new Object[]{MetricDataType.LONG_GAUGE, ((MetricData)this.actual).getType()});
        }
        return new GaugeAssert<LongPointData>(((MetricData)this.actual).getLongGaugeData());
    }

    public SumDataAssert<LongPointData> hasLongSum() {
        this.isNotNull();
        if (((MetricData)this.actual).getType() != MetricDataType.LONG_SUM) {
            this.failWithActualExpectedAndMessage(this.actual, "type: LONG_SUM", "Expected MetricData to have type <%s> but found <%s>", new Object[]{MetricDataType.LONG_SUM, ((MetricData)this.actual).getType()});
        }
        return new SumDataAssert<LongPointData>(((MetricData)this.actual).getLongSumData());
    }

    public SummaryDataAssert hasDoubleSummary() {
        this.isNotNull();
        if (((MetricData)this.actual).getType() != MetricDataType.SUMMARY) {
            this.failWithActualExpectedAndMessage(this.actual, "type: SUMMARY", "Expected MetricData to have type <%s> but found <%s>", new Object[]{MetricDataType.SUMMARY, ((MetricData)this.actual).getType()});
        }
        return new SummaryDataAssert(((MetricData)this.actual).getSummaryData());
    }
}

