/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.view;

import io.opentelemetry.sdk.metrics.internal.view.StringPredicates;
import io.opentelemetry.sdk.metrics.view.MeterSelector;
import java.util.Objects;
import java.util.function.Predicate;

public final class MeterSelectorBuilder {
    private Predicate<String> nameFilter = StringPredicates.ALL;
    private Predicate<String> versionFilter = StringPredicates.ALL;
    private Predicate<String> schemaUrlFilter = StringPredicates.ALL;

    public MeterSelectorBuilder setName(String name) {
        Objects.requireNonNull(name, "name");
        return this.setName(StringPredicates.exact(name));
    }

    public MeterSelectorBuilder setName(Predicate<String> nameFilter) {
        Objects.requireNonNull(nameFilter, "nameFilter");
        this.nameFilter = nameFilter;
        return this;
    }

    public MeterSelectorBuilder setVersion(Predicate<String> versionFilter) {
        Objects.requireNonNull(versionFilter, "versionFilter");
        this.versionFilter = versionFilter;
        return this;
    }

    public MeterSelectorBuilder setVersion(String version) {
        Objects.requireNonNull(version, "version");
        return this.setVersion(StringPredicates.exact(version));
    }

    public MeterSelectorBuilder setSchemaUrl(String schemaUrl) {
        Objects.requireNonNull(schemaUrl, "schemaUrl");
        return this.setSchemaUrl(StringPredicates.exact(schemaUrl));
    }

    public MeterSelectorBuilder setSchemaUrl(Predicate<String> schemaUrlFilter) {
        Objects.requireNonNull(schemaUrlFilter, "schemaUrlFilter");
        this.schemaUrlFilter = schemaUrlFilter;
        return this;
    }

    public MeterSelector build() {
        return MeterSelector.create(this.nameFilter, this.versionFilter, this.schemaUrlFilter);
    }
}

