/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.view;

import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.internal.view.StringPredicates;
import io.opentelemetry.sdk.metrics.view.InstrumentSelector;
import io.opentelemetry.sdk.metrics.view.MeterSelector;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class InstrumentSelectorBuilder {
    @Nullable
    private InstrumentType instrumentType;
    private Predicate<String> instrumentNameFilter = StringPredicates.ALL;
    private MeterSelector meterSelector = MeterSelector.builder().build();

    public InstrumentSelectorBuilder setType(InstrumentType instrumentType) {
        Objects.requireNonNull(instrumentType, "instrumentType");
        this.instrumentType = instrumentType;
        return this;
    }

    public InstrumentSelectorBuilder setName(String name) {
        Objects.requireNonNull(name, "name");
        return this.setName(StringPredicates.exact(name));
    }

    public InstrumentSelectorBuilder setName(Predicate<String> nameFilter) {
        Objects.requireNonNull(nameFilter, "nameFilter");
        this.instrumentNameFilter = nameFilter;
        return this;
    }

    public InstrumentSelectorBuilder setMeterSelector(MeterSelector meterSelector) {
        Objects.requireNonNull(meterSelector, "meterSelector");
        this.meterSelector = meterSelector;
        return this;
    }

    public InstrumentSelector build() {
        return InstrumentSelector.create(this.instrumentType, this.instrumentNameFilter, this.meterSelector);
    }
}

