/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.internal.ThrowableUtil;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.internal.aggregator.EmptyMetricData;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.export.CollectionInfo;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.TemporalMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.TemporalityUtils;
import io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import io.opentelemetry.sdk.metrics.view.View;
import io.opentelemetry.sdk.resources.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AsynchronousMetricStorage<T, O>
implements MetricStorage {
    private static final Logger logger = Logger.getLogger(AsynchronousMetricStorage.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final ReentrantLock collectLock = new ReentrantLock();
    private final List<Consumer<O>> callbacks = new CopyOnWriteArrayList<Consumer<O>>();
    private final MetricDescriptor metricDescriptor;
    private final TemporalMetricStorage<T> storage;
    private final AsyncAccumulator<T> accumulator;
    private final O measurement;

    private AsynchronousMetricStorage(MetricDescriptor metricDescriptor, Aggregator<T> aggregator, AsyncAccumulator<T> accumulator, O measurement) {
        this.metricDescriptor = metricDescriptor;
        this.storage = new TemporalMetricStorage<T>(aggregator, false);
        this.accumulator = accumulator;
        this.measurement = measurement;
    }

    public static <T> AsynchronousMetricStorage<?, ObservableDoubleMeasurement> createDoubleAsyncStorage(View view, InstrumentDescriptor instrument) {
        MetricDescriptor metricDescriptor = MetricDescriptor.create(view, instrument);
        Aggregator aggregator = ((AggregatorFactory)((Object)view.getAggregation())).createAggregator(instrument, ExemplarFilter.neverSample());
        AsyncAccumulator accumulator = new AsyncAccumulator(instrument);
        ObservableDoubleMeasurementImpl measurement = new ObservableDoubleMeasurementImpl(aggregator, accumulator, view.getAttributesProcessor());
        return new AsynchronousMetricStorage(metricDescriptor, aggregator, accumulator, measurement);
    }

    public static <T> AsynchronousMetricStorage<?, ObservableLongMeasurement> createLongAsyncStorage(View view, InstrumentDescriptor instrument) {
        MetricDescriptor metricDescriptor = MetricDescriptor.create(view, instrument);
        Aggregator aggregator = ((AggregatorFactory)((Object)view.getAggregation())).createAggregator(instrument, ExemplarFilter.neverSample());
        AsyncAccumulator accumulator = new AsyncAccumulator(instrument);
        ObservableLongMeasurementImpl measurement = new ObservableLongMeasurementImpl(aggregator, accumulator, view.getAttributesProcessor());
        return new AsynchronousMetricStorage(metricDescriptor, aggregator, accumulator, measurement);
    }

    @Override
    public MetricDescriptor getMetricDescriptor() {
        return this.metricDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MetricData collectAndReset(CollectionInfo collectionInfo, Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, long startEpochNanos, long epochNanos, boolean suppressSynchronousCollection) {
        AggregationTemporality temporality = TemporalityUtils.resolveTemporality(collectionInfo.getPreferredAggregation());
        this.collectLock.lock();
        try {
            boolean empty = true;
            for (Consumer<O> callback : this.callbacks) {
                empty = false;
                callback.accept(this.measurement);
            }
            if (empty) {
                MetricData metricData = EmptyMetricData.getInstance();
                return metricData;
            }
            MetricData metricData = this.storage.buildMetricFor(collectionInfo.getCollector(), resource, instrumentationLibraryInfo, this.getMetricDescriptor(), temporality, this.accumulator.collectAndReset(), startEpochNanos, epochNanos);
            return metricData;
        }
        catch (Throwable e) {
            ThrowableUtil.propagateIfFatal(e);
            this.throttlingLogger.log(Level.WARNING, "An exception occurred invoking callback for instrument " + this.getMetricDescriptor().getName() + ".", e);
            MetricData metricData = EmptyMetricData.getInstance();
            return metricData;
        }
        finally {
            this.collectLock.unlock();
        }
    }

    public void addCallback(Consumer<O> callback) {
        this.callbacks.add(callback);
    }

    public void removeCallback(Consumer<O> callback) {
        this.callbacks.remove(callback);
    }

    static /* synthetic */ Logger access$200() {
        return logger;
    }

    static final class AsyncAccumulator<T> {
        private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(AsynchronousMetricStorage.access$200());
        private final InstrumentDescriptor instrument;
        private Map<Attributes, T> currentAccumulation = new HashMap<Attributes, T>();

        AsyncAccumulator(InstrumentDescriptor instrument) {
            this.instrument = instrument;
        }

        void record(Attributes attributes, T accumulation) {
            if (this.currentAccumulation.size() >= 2000) {
                this.throttlingLogger.log(Level.WARNING, "Instrument " + this.instrument.getName() + " has exceeded the maximum allowed accumulations (" + 2000 + ").");
                return;
            }
            if (this.currentAccumulation.containsKey(attributes)) {
                this.throttlingLogger.log(Level.WARNING, "Instrument " + this.instrument.getName() + " has recorded multiple values for the same attributes.");
                return;
            }
            this.currentAccumulation.put(attributes, accumulation);
        }

        Map<Attributes, T> collectAndReset() {
            Map<Attributes, T> result = this.currentAccumulation;
            this.currentAccumulation = new HashMap<Attributes, T>();
            return result;
        }
    }

    private static class ObservableDoubleMeasurementImpl<T>
    implements ObservableDoubleMeasurement {
        private final Aggregator<T> aggregator;
        private final AsyncAccumulator<T> asyncAccumulator;
        private final AttributesProcessor attributesProcessor;

        private ObservableDoubleMeasurementImpl(Aggregator<T> aggregator, AsyncAccumulator<T> asyncAccumulator, AttributesProcessor attributesProcessor) {
            this.aggregator = aggregator;
            this.asyncAccumulator = asyncAccumulator;
            this.attributesProcessor = attributesProcessor;
        }

        @Override
        public void record(double value) {
            this.record(value, Attributes.empty());
        }

        @Override
        public void record(double value, Attributes attributes) {
            T accumulation = this.aggregator.accumulateDoubleMeasurement(value, attributes, Context.current());
            if (accumulation != null) {
                this.asyncAccumulator.record(this.attributesProcessor.process(attributes, Context.current()), accumulation);
            }
        }
    }

    private static class ObservableLongMeasurementImpl<T>
    implements ObservableLongMeasurement {
        private final Aggregator<T> aggregator;
        private final AsyncAccumulator<T> asyncAccumulator;
        private final AttributesProcessor attributesProcessor;

        private ObservableLongMeasurementImpl(Aggregator<T> aggregator, AsyncAccumulator<T> asyncAccumulator, AttributesProcessor attributesProcessor) {
            this.aggregator = aggregator;
            this.asyncAccumulator = asyncAccumulator;
            this.attributesProcessor = attributesProcessor;
        }

        @Override
        public void record(long value) {
            this.record(value, Attributes.empty());
        }

        @Override
        public void record(long value, Attributes attributes) {
            T accumulation = this.aggregator.accumulateLongMeasurement(value, attributes, Context.current());
            if (accumulation != null) {
                this.asyncAccumulator.record(this.attributesProcessor.process(attributes, Context.current()), accumulation);
            }
        }
    }
}

