/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus;

import io.opentelemetry.exporter.prometheus.PrometheusHttpServer;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.MetricReaderFactory;
import java.net.InetSocketAddress;
import javax.annotation.Nullable;

class PrometheusHttpServerFactory
implements MetricReaderFactory {
    private final String host;
    private final int port;
    @Nullable
    private PrometheusHttpServer server;

    PrometheusHttpServerFactory(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public MetricReader apply(MetricProducer producer) {
        this.server = new PrometheusHttpServer(this.host, this.port, producer);
        return this.server;
    }

    InetSocketAddress getAddress() {
        PrometheusHttpServer server = this.server;
        if (server != null) {
            return server.getAddress();
        }
        throw new IllegalStateException("Server not started. Call after SdkMeterProviderBuilder.build()");
    }
}

