/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.sdk.internal.PrimitiveLongList;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramBuckets;
import io.opentelemetry.sdk.metrics.internal.aggregator.BucketMapper;
import io.opentelemetry.sdk.metrics.internal.state.ExponentialCounter;
import io.opentelemetry.sdk.metrics.internal.state.ExponentialCounterFactory;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class DoubleExponentialHistogramBuckets
implements ExponentialHistogramBuckets {
    private final ExponentialCounterFactory counterFactory;
    private ExponentialCounter counts;
    private BucketMapper bucketMapper;
    private int scale;

    DoubleExponentialHistogramBuckets(int scale, int maxBuckets, ExponentialCounterFactory counterFactory) {
        this.counterFactory = counterFactory;
        this.counts = counterFactory.newCounter(maxBuckets);
        this.bucketMapper = new LogarithmMapper(scale);
        this.scale = scale;
    }

    DoubleExponentialHistogramBuckets(DoubleExponentialHistogramBuckets buckets) {
        this.counterFactory = buckets.counterFactory;
        this.counts = this.counterFactory.copy(buckets.counts);
        this.bucketMapper = new LogarithmMapper(buckets.scale);
        this.scale = buckets.scale;
    }

    DoubleExponentialHistogramBuckets copy() {
        return new DoubleExponentialHistogramBuckets(this);
    }

    public void clear() {
        this.counts.clear();
    }

    boolean record(double value) {
        if (value == 0.0) {
            throw new IllegalStateException("Illegal attempted recording of zero at bucket level.");
        }
        int index = this.bucketMapper.valueToIndex(Math.abs(value));
        return this.counts.increment(index, 1L);
    }

    @Override
    public int getOffset() {
        if (this.counts.isEmpty()) {
            return 0;
        }
        return this.counts.getIndexStart();
    }

    @Override
    @Nonnull
    public List<Long> getBucketCounts() {
        if (this.counts.isEmpty()) {
            return Collections.emptyList();
        }
        int length = this.counts.getIndexEnd() - this.counts.getIndexStart() + 1;
        long[] countsArr = new long[length];
        for (int i = 0; i < length; ++i) {
            countsArr[i] = this.counts.get(i + this.counts.getIndexStart());
        }
        return PrimitiveLongList.wrap(countsArr);
    }

    @Override
    public long getTotalCount() {
        if (this.counts.isEmpty()) {
            return 0L;
        }
        long totalCount = 0L;
        for (int i = this.counts.getIndexStart(); i <= this.counts.getIndexEnd(); ++i) {
            totalCount += this.counts.get(i);
        }
        return totalCount;
    }

    void downscale(int by) {
        if (by == 0) {
            return;
        }
        if (by < 0) {
            throw new IllegalStateException("Cannot downscale by negative amount. Was given " + by + ".");
        }
        if (!this.counts.isEmpty()) {
            ExponentialCounter newCounts = this.counterFactory.copy(this.counts);
            newCounts.clear();
            for (int i = this.counts.getIndexStart(); i <= this.counts.getIndexEnd(); ++i) {
                long count = this.counts.get(i);
                if (count <= 0L || newCounts.increment(i >> by, count)) continue;
                throw new IllegalStateException("Failed to create new downscaled buckets.");
            }
            this.counts = newCounts;
        }
        this.scale -= by;
        this.bucketMapper = new LogarithmMapper(this.scale);
    }

    static DoubleExponentialHistogramBuckets diff(DoubleExponentialHistogramBuckets a, DoubleExponentialHistogramBuckets b) {
        DoubleExponentialHistogramBuckets copy = a.copy();
        copy.mergeWith(b, false);
        return copy;
    }

    static DoubleExponentialHistogramBuckets merge(DoubleExponentialHistogramBuckets a, DoubleExponentialHistogramBuckets b) {
        if (b.counts.isEmpty()) {
            return a;
        }
        if (a.counts.isEmpty()) {
            return b;
        }
        DoubleExponentialHistogramBuckets copy = a.copy();
        copy.mergeWith(b, true);
        return copy;
    }

    private void mergeWith(DoubleExponentialHistogramBuckets other, boolean additive) {
        long newWindowEnd;
        long newWindowStart;
        if (other.counts.isEmpty()) {
            return;
        }
        int commonScale = Math.min(this.scale, other.scale);
        int deltaThis = this.scale - commonScale;
        int deltaOther = other.scale - commonScale;
        if (this.counts.isEmpty()) {
            newWindowStart = other.getOffset() >> deltaOther;
            newWindowEnd = other.counts.getIndexEnd() >> deltaOther;
        } else {
            newWindowStart = Math.min(this.getOffset() >> deltaThis, other.getOffset() >> deltaOther);
            newWindowEnd = Math.max(this.counts.getIndexEnd() >> deltaThis, other.counts.getIndexEnd() >> deltaOther);
        }
        this.downscale(deltaThis += this.getScaleReduction(newWindowStart, newWindowEnd));
        deltaOther = other.scale - this.scale;
        int sign = additive ? 1 : -1;
        for (int i = other.getOffset(); i <= other.counts.getIndexEnd(); ++i) {
            if (this.counts.increment(i >> deltaOther, (long)sign * other.counts.get(i))) continue;
            throw new IllegalStateException("Failed to merge exponential histogram buckets.");
        }
    }

    int getScale() {
        return this.scale;
    }

    int getScaleReduction(double value) {
        long index = this.bucketMapper.valueToIndex(Math.abs(value));
        long newStart = Math.min(index, (long)this.counts.getIndexStart());
        long newEnd = Math.max(index, (long)this.counts.getIndexEnd());
        return this.getScaleReduction(newStart, newEnd);
    }

    int getScaleReduction(long newStart, long newEnd) {
        int scaleReduction = 0;
        while (newEnd - newStart + 1L > (long)this.counts.getMaxSize()) {
            newStart >>= 1;
            newEnd >>= 1;
            ++scaleReduction;
        }
        return scaleReduction;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof DoubleExponentialHistogramBuckets)) {
            return false;
        }
        DoubleExponentialHistogramBuckets other = (DoubleExponentialHistogramBuckets)obj;
        return this.scale == other.scale && this.sameBucketCounts(other);
    }

    private boolean sameBucketCounts(DoubleExponentialHistogramBuckets other) {
        int min2 = Math.min(this.counts.getIndexStart(), other.counts.getIndexStart());
        int max = Math.max(this.counts.getIndexEnd(), other.counts.getIndexEnd());
        for (int idx = min2; idx <= max; ++idx) {
            if (this.counts.get(idx) == other.counts.get(idx)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 1;
        hash *= 1000003;
        for (int idx = this.counts.getIndexStart(); idx <= this.counts.getIndexEnd(); ++idx) {
            long count = this.counts.get(idx);
            if (count == 0L) continue;
            hash ^= idx;
            hash *= 1000003;
            hash = (int)((long)hash ^ count);
            hash *= 1000003;
        }
        return hash ^= this.scale;
    }

    public String toString() {
        return "DoubleExponentialHistogramBuckets{scale: " + this.scale + ", offset: " + this.getOffset() + ", counts: " + this.counts + " }";
    }

    private static class LogarithmMapper
    implements BucketMapper {
        private final double scaleFactor;

        LogarithmMapper(int scale) {
            this.scaleFactor = Math.scalb(1.0 / Math.log(2.0), scale);
        }

        @Override
        public int valueToIndex(double value) {
            return (int)Math.floor(Math.log(value) * this.scaleFactor);
        }
    }
}

