/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleUpDownCounter;
import io.opentelemetry.api.metrics.DoubleUpDownCounterBuilder;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableDoubleUpDownCounter;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrumentBuilder;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.instrument.BoundDoubleUpDownCounter;
import io.opentelemetry.sdk.metrics.internal.state.BoundStorageHandle;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.function.Consumer;

final class SdkDoubleUpDownCounter
extends AbstractInstrument
implements DoubleUpDownCounter {
    private static final ObservableDoubleUpDownCounter NOOP = new ObservableDoubleUpDownCounter(){};
    private final WriteableMetricStorage storage;

    private SdkDoubleUpDownCounter(InstrumentDescriptor descriptor, WriteableMetricStorage storage) {
        super(descriptor);
        this.storage = storage;
    }

    @Override
    public void add(double increment, Attributes attributes, Context context) {
        this.storage.recordDouble(increment, attributes, context);
    }

    @Override
    public void add(double increment, Attributes attributes) {
        this.add(increment, attributes, Context.current());
    }

    @Override
    public void add(double increment) {
        this.add(increment, Attributes.empty());
    }

    BoundDoubleUpDownCounter bind(Attributes attributes) {
        return new BoundInstrument(this.storage.bind(attributes), attributes);
    }

    static final class BoundInstrument
    implements BoundDoubleUpDownCounter {
        private final BoundStorageHandle handle;
        private final Attributes attributes;

        BoundInstrument(BoundStorageHandle handle, Attributes attributes) {
            this.handle = handle;
            this.attributes = attributes;
        }

        @Override
        public void add(double increment, Context context) {
            this.handle.recordDouble(increment, this.attributes, context);
        }

        @Override
        public void add(double increment) {
            this.add(increment, Context.current());
        }

        @Override
        public void unbind() {
            this.handle.release();
        }
    }

    static final class Builder
    extends AbstractInstrumentBuilder<Builder>
    implements DoubleUpDownCounterBuilder {
        Builder(MeterProviderSharedState meterProviderSharedState, MeterSharedState sharedState, String name, String description, String unit) {
            super(meterProviderSharedState, sharedState, name, description, unit);
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public DoubleUpDownCounter build() {
            return this.buildSynchronousInstrument(InstrumentType.UP_DOWN_COUNTER, InstrumentValueType.DOUBLE, (x$0, x$1) -> new SdkDoubleUpDownCounter((InstrumentDescriptor)x$0, (WriteableMetricStorage)x$1));
        }

        @Override
        public ObservableDoubleUpDownCounter buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            this.registerDoubleAsynchronousInstrument(InstrumentType.OBSERVABLE_UP_DOWN_COUNTER, callback);
            return NOOP;
        }
    }
}

