/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServerFactory;
import io.opentelemetry.sdk.metrics.export.MetricReaderFactory;
import java.util.Objects;

public final class PrometheusHttpServerBuilder {
    static final int DEFAULT_PORT = 9464;
    private static final String DEFAULT_HOST = "0.0.0.0";
    private String host = "0.0.0.0";
    private int port = 9464;

    public PrometheusHttpServerBuilder setHost(String host) {
        Objects.requireNonNull(host, "host");
        Utils.checkArgument(!host.isEmpty(), "host must not be empty");
        this.host = host;
        return this;
    }

    public PrometheusHttpServerBuilder setPort(int port) {
        Utils.checkArgument(port >= 0, "port must be positive");
        this.port = port;
        return this;
    }

    public MetricReaderFactory newMetricReaderFactory() {
        return new PrometheusHttpServerFactory(this.host, this.port);
    }

    PrometheusHttpServerBuilder() {
    }
}

