/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import io.opentelemetry.exporter.prometheus.MetricAdapter;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServerBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.DaemonThreadFactory;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.MetricReaderFactory;
import io.prometheus.client.Collector;
import io.prometheus.client.Predicate;
import io.prometheus.client.SampleNameFilter;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;

public final class PrometheusHttpServer
implements Closeable,
MetricReader {
    private static final DaemonThreadFactory THREAD_FACTORY = new DaemonThreadFactory("prometheus-http");
    private final HttpServer server;
    private final ExecutorService executor;

    public static MetricReaderFactory newMetricReaderFactory() {
        return PrometheusHttpServer.builder().newMetricReaderFactory();
    }

    public static PrometheusHttpServerBuilder builder() {
        return new PrometheusHttpServerBuilder();
    }

    PrometheusHttpServer(String host, int port, MetricProducer producer) {
        try {
            this.server = HttpServer.create(new InetSocketAddress(host, port), 3);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not create Prometheus HTTP server", e);
        }
        this.server.createContext("/", new MetricsHandler(producer));
        this.server.createContext("/metrics", new MetricsHandler(producer));
        this.server.createContext("/-/healthy", HealthHandler.INSTANCE);
        this.executor = Executors.newFixedThreadPool(5, THREAD_FACTORY);
        this.server.setExecutor(this.executor);
        this.start();
    }

    private void start() {
        if (Thread.currentThread().isDaemon()) {
            this.server.start();
            return;
        }
        Thread thread2 = THREAD_FACTORY.newThread(this.server::start);
        thread2.start();
        try {
            thread2.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public AggregationTemporality getPreferredTemporality() {
        return AggregationTemporality.CUMULATIVE;
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        CompletableResultCode result = new CompletableResultCode();
        Thread thread2 = THREAD_FACTORY.newThread(() -> {
            try {
                this.server.stop(10);
                this.executor.shutdownNow();
            }
            catch (Throwable t) {
                result.fail();
                return;
            }
            result.succeed();
        });
        thread2.start();
        return result;
    }

    @Override
    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }

    InetSocketAddress getAddress() {
        return this.server.getAddress();
    }

    private static boolean shouldUseCompression(HttpExchange exchange) {
        Object encodingHeaders = exchange.getRequestHeaders().get("Accept-Encoding");
        if (encodingHeaders == null) {
            return false;
        }
        Iterator iterator2 = encodingHeaders.iterator();
        while (iterator2.hasNext()) {
            String[] encodings;
            String encodingHeader = (String)iterator2.next();
            for (String encoding : encodings = encodingHeader.split(",")) {
                if (!encoding.trim().equalsIgnoreCase("gzip")) continue;
                return true;
            }
        }
        return false;
    }

    private static Set<String> parseQuery(@Nullable String query) throws IOException {
        String[] pairs;
        if (query == null) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>();
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            if (idx == -1 || !URLDecoder.decode(pair.substring(0, idx), "UTF-8").equals("name[]")) continue;
            names.add(URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
        }
        return names;
    }

    private static class MetricsHandler
    implements HttpHandler {
        private final MetricProducer producer;

        private MetricsHandler(MetricProducer producer) {
            this.producer = producer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String contentType = TextFormat.chooseContentType(exchange.getRequestHeaders().getFirst("Accept"));
            exchange.getResponseHeaders().set("Content-Type", contentType);
            Collection<MetricData> metrics = this.producer.collectAllMetrics();
            ArrayList<Collector.MetricFamilySamples> samples = new ArrayList<Collector.MetricFamilySamples>(metrics.size());
            Predicate<String> filter = SampleNameFilter.restrictToNamesEqualTo(null, PrometheusHttpServer.parseQuery(exchange.getRequestURI().getRawQuery()));
            for (MetricData metric : metrics) {
                Collector.MetricFamilySamples sample = MetricAdapter.toMetricFamilySamples(metric).filter(filter);
                if (sample == null) continue;
                samples.add(sample);
            }
            boolean compress = PrometheusHttpServer.shouldUseCompression(exchange);
            if (compress) {
                exchange.getResponseHeaders().set("Content-Encoding", "gzip");
            }
            if (exchange.getRequestMethod().equals("HEAD")) {
                exchange.sendResponseHeaders(200, -1L);
            } else {
                exchange.sendResponseHeaders(200, 0L);
                try (OutputStreamWriter writer = compress ? new OutputStreamWriter((OutputStream)new GZIPOutputStream(exchange.getResponseBody()), StandardCharsets.UTF_8) : new OutputStreamWriter(exchange.getResponseBody(), StandardCharsets.UTF_8);){
                    TextFormat.writeFormat(contentType, writer, Collections.enumeration(samples));
                }
            }
            exchange.close();
        }
    }

    private static enum HealthHandler implements HttpHandler
    {
        INSTANCE;

        private static final byte[] RESPONSE;
        private static final String CONTENT_LENGTH_VALUE;

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            exchange.getResponseHeaders().set("Content-Length", CONTENT_LENGTH_VALUE);
            if (exchange.getRequestMethod().equals("HEAD")) {
                exchange.sendResponseHeaders(200, -1L);
            } else {
                exchange.sendResponseHeaders(200, RESPONSE.length);
                exchange.getResponseBody().write(RESPONSE);
            }
            exchange.close();
        }

        static {
            RESPONSE = "Exporter is Healthy.".getBytes(StandardCharsets.UTF_8);
            CONTENT_LENGTH_VALUE = String.valueOf(RESPONSE.length);
        }
    }
}

