/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus;

import io.opentelemetry.exporter.prometheus.MetricAdapter;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricProducer;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.MetricReaderFactory;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class PrometheusCollector
extends Collector
implements MetricReader {
    private final MetricProducer metricProducer;
    private volatile boolean registered = false;

    PrometheusCollector(MetricProducer metricProducer) {
        this.metricProducer = metricProducer;
    }

    @Override
    public <T extends Collector> T register() {
        Object result = super.register();
        this.registered = true;
        return result;
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        if (!this.registered) {
            return Collections.emptyList();
        }
        Collection<MetricData> allMetrics = this.metricProducer.collectAllMetrics();
        ArrayList<Collector.MetricFamilySamples> allSamples = new ArrayList<Collector.MetricFamilySamples>(allMetrics.size());
        for (MetricData metricData : allMetrics) {
            allSamples.add(MetricAdapter.toMetricFamilySamples(metricData));
        }
        return Collections.unmodifiableList(allSamples);
    }

    public static MetricReaderFactory create() {
        return new Factory();
    }

    @Override
    public AggregationTemporality getPreferredTemporality() {
        return AggregationTemporality.CUMULATIVE;
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        CollectorRegistry.defaultRegistry.unregister(this);
        return CompletableResultCode.ofSuccess();
    }

    private static class Factory
    implements MetricReaderFactory {
        private Factory() {
        }

        @Override
        public MetricReader apply(MetricProducer producer) {
            PrometheusCollector collector = new PrometheusCollector(producer);
            collector.register();
            return collector;
        }
    }
}

