/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.prometheus;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.exporter.prometheus.LabelNameSanitizer;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoubleHistogramPointData;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.DoubleSumData;
import io.opentelemetry.sdk.metrics.data.DoubleSummaryPointData;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.LongSumData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.metrics.data.PointData;
import io.opentelemetry.sdk.metrics.data.ValueAtPercentile;
import io.prometheus.client.Collector;
import io.prometheus.client.exemplars.Exemplar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;

final class MetricAdapter {
    static final String SAMPLE_SUFFIX_COUNT = "_count";
    static final String SAMPLE_SUFFIX_SUM = "_sum";
    static final String SAMPLE_SUFFIX_BUCKET = "_bucket";
    static final String LABEL_NAME_QUANTILE = "quantile";
    static final String LABEL_NAME_LE = "le";
    private static final Function<String, String> sanitizer = new LabelNameSanitizer();

    static Collector.MetricFamilySamples toMetricFamilySamples(MetricData metricData) {
        String cleanMetricName = MetricAdapter.cleanMetricName(metricData.getName());
        Collector.Type type = MetricAdapter.toMetricFamilyType(metricData);
        return new Collector.MetricFamilySamples(cleanMetricName, type, metricData.getDescription(), MetricAdapter.toSamples(cleanMetricName, metricData.getType(), MetricAdapter.getPoints(metricData)));
    }

    private static String cleanMetricName(String descriptorMetricName) {
        return Collector.sanitizeMetricName(descriptorMetricName);
    }

    static Collector.Type toMetricFamilyType(MetricData metricData) {
        switch (metricData.getType()) {
            case LONG_GAUGE: 
            case DOUBLE_GAUGE: {
                return Collector.Type.GAUGE;
            }
            case LONG_SUM: {
                LongSumData longSumData = metricData.getLongSumData();
                if (longSumData.isMonotonic() && longSumData.getAggregationTemporality() == AggregationTemporality.CUMULATIVE) {
                    return Collector.Type.COUNTER;
                }
                return Collector.Type.GAUGE;
            }
            case DOUBLE_SUM: {
                DoubleSumData doubleSumData = metricData.getDoubleSumData();
                if (doubleSumData.isMonotonic() && doubleSumData.getAggregationTemporality() == AggregationTemporality.CUMULATIVE) {
                    return Collector.Type.COUNTER;
                }
                return Collector.Type.GAUGE;
            }
            case SUMMARY: {
                return Collector.Type.SUMMARY;
            }
            case HISTOGRAM: {
                return Collector.Type.HISTOGRAM;
            }
            case EXPONENTIAL_HISTOGRAM: {
                return Collector.Type.UNKNOWN;
            }
        }
        return Collector.Type.UNKNOWN;
    }

    static List<Collector.MetricFamilySamples.Sample> toSamples(String name, MetricDataType type, Collection<? extends PointData> points) {
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>(MetricAdapter.estimateNumSamples(points.size(), type));
        for (PointData pointData : points) {
            Attributes attributes = pointData.getAttributes();
            ArrayList<String> labelNames = new ArrayList<String>(attributes.size());
            ArrayList<String> labelValues = new ArrayList<String>(attributes.size());
            attributes.forEach((key, value) -> {
                String sanitizedLabelName = sanitizer.apply(key.getKey());
                labelNames.add(sanitizedLabelName);
                labelValues.add(value == null ? "" : value.toString());
            });
            switch (type) {
                case DOUBLE_GAUGE: 
                case DOUBLE_SUM: {
                    DoublePointData doublePoint = (DoublePointData)pointData;
                    samples.add(MetricAdapter.createSample(name, labelNames, labelValues, doublePoint.getValue(), null, doublePoint.getEpochNanos()));
                    break;
                }
                case LONG_GAUGE: 
                case LONG_SUM: {
                    LongPointData longPoint = (LongPointData)pointData;
                    samples.add(MetricAdapter.createSample(name, labelNames, labelValues, longPoint.getValue(), null, longPoint.getEpochNanos()));
                    break;
                }
                case SUMMARY: {
                    MetricAdapter.addSummarySamples((DoubleSummaryPointData)pointData, name, labelNames, labelValues, samples);
                    break;
                }
                case HISTOGRAM: {
                    MetricAdapter.addHistogramSamples((DoubleHistogramPointData)pointData, name, labelNames, labelValues, samples);
                    break;
                }
            }
        }
        return samples;
    }

    private static void addSummarySamples(DoubleSummaryPointData doubleSummaryPoint, String name, List<String> labelNames, List<String> labelValues, List<Collector.MetricFamilySamples.Sample> samples) {
        samples.add(MetricAdapter.createSample(name + SAMPLE_SUFFIX_COUNT, labelNames, labelValues, doubleSummaryPoint.getCount(), null, doubleSummaryPoint.getEpochNanos()));
        samples.add(MetricAdapter.createSample(name + SAMPLE_SUFFIX_SUM, labelNames, labelValues, doubleSummaryPoint.getSum(), null, doubleSummaryPoint.getEpochNanos()));
        List<ValueAtPercentile> valueAtPercentiles = doubleSummaryPoint.getPercentileValues();
        ArrayList<String> labelNamesWithQuantile = new ArrayList<String>(labelNames.size());
        labelNamesWithQuantile.addAll(labelNames);
        labelNamesWithQuantile.add(LABEL_NAME_QUANTILE);
        for (ValueAtPercentile valueAtPercentile : valueAtPercentiles) {
            ArrayList<String> labelValuesWithQuantile = new ArrayList<String>(labelValues.size());
            labelValuesWithQuantile.addAll(labelValues);
            labelValuesWithQuantile.add(Collector.doubleToGoString(valueAtPercentile.getPercentile()));
            samples.add(MetricAdapter.createSample(name, labelNamesWithQuantile, labelValuesWithQuantile, valueAtPercentile.getValue(), null, doubleSummaryPoint.getEpochNanos()));
        }
    }

    private static void addHistogramSamples(DoubleHistogramPointData doubleHistogramPointData, String name, List<String> labelNames, List<String> labelValues, List<Collector.MetricFamilySamples.Sample> samples) {
        samples.add(MetricAdapter.createSample(name + SAMPLE_SUFFIX_COUNT, labelNames, labelValues, doubleHistogramPointData.getCount(), null, doubleHistogramPointData.getEpochNanos()));
        samples.add(MetricAdapter.createSample(name + SAMPLE_SUFFIX_SUM, labelNames, labelValues, doubleHistogramPointData.getSum(), null, doubleHistogramPointData.getEpochNanos()));
        ArrayList<String> labelNamesWithLe = new ArrayList<String>(labelNames.size() + 1);
        labelNamesWithLe.addAll(labelNames);
        labelNamesWithLe.add(LABEL_NAME_LE);
        long cumulativeCount = 0L;
        List<Long> counts = doubleHistogramPointData.getCounts();
        for (int i = 0; i < counts.size(); ++i) {
            ArrayList<String> labelValuesWithLe = new ArrayList<String>(labelValues.size() + 1);
            double boundary = doubleHistogramPointData.getBucketUpperBound(i);
            labelValuesWithLe.addAll(labelValues);
            labelValuesWithLe.add(Collector.doubleToGoString(boundary));
            samples.add(MetricAdapter.createSample(name + SAMPLE_SUFFIX_BUCKET, labelNamesWithLe, labelValuesWithLe, cumulativeCount += counts.get(i).longValue(), MetricAdapter.filterExemplars(doubleHistogramPointData.getExemplars(), doubleHistogramPointData.getBucketLowerBound(i), boundary), doubleHistogramPointData.getEpochNanos()));
        }
    }

    @Nullable
    private static ExemplarData filterExemplars(Collection<ExemplarData> exemplars, double min2, double max) {
        ExemplarData result = null;
        for (ExemplarData e : exemplars) {
            double value = e.getValueAsDouble();
            if (!(value <= max) || !(value > min2)) continue;
            result = e;
        }
        return result;
    }

    private static int estimateNumSamples(int numPoints, MetricDataType type) {
        if (type == MetricDataType.SUMMARY) {
            return numPoints * 4;
        }
        return numPoints;
    }

    private static Collection<? extends PointData> getPoints(MetricData metricData) {
        switch (metricData.getType()) {
            case DOUBLE_GAUGE: {
                return metricData.getDoubleGaugeData().getPoints();
            }
            case DOUBLE_SUM: {
                return metricData.getDoubleSumData().getPoints();
            }
            case LONG_GAUGE: {
                return metricData.getLongGaugeData().getPoints();
            }
            case LONG_SUM: {
                return metricData.getLongSumData().getPoints();
            }
            case SUMMARY: {
                return metricData.getDoubleSummaryData().getPoints();
            }
            case HISTOGRAM: {
                return metricData.getDoubleHistogramData().getPoints();
            }
            case EXPONENTIAL_HISTOGRAM: {
                return metricData.getExponentialHistogramData().getPoints();
            }
        }
        return Collections.emptyList();
    }

    private static Collector.MetricFamilySamples.Sample createSample(String name, List<String> labelNames, List<String> labelValues, double value, @Nullable ExemplarData exemplar, long timestampNanos) {
        if (exemplar != null) {
            return new Collector.MetricFamilySamples.Sample(name, labelNames, labelValues, value, MetricAdapter.toPrometheusExemplar(exemplar), TimeUnit.MILLISECONDS.convert(timestampNanos, TimeUnit.NANOSECONDS));
        }
        return new Collector.MetricFamilySamples.Sample(name, labelNames, labelValues, value, null, TimeUnit.MILLISECONDS.convert(timestampNanos, TimeUnit.NANOSECONDS));
    }

    private static Exemplar toPrometheusExemplar(ExemplarData exemplar) {
        if (exemplar.getSpanId() != null && exemplar.getTraceId() != null) {
            return new Exemplar(exemplar.getValueAsDouble(), (Long)TimeUnit.NANOSECONDS.toMillis(exemplar.getEpochNanos()), "trace_id", exemplar.getTraceId(), "span_id", exemplar.getSpanId());
        }
        return new Exemplar(exemplar.getValueAsDouble(), new String[0]);
    }

    private MetricAdapter() {
    }
}

