/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.traces;

import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.ProtoEnumInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.proto.trace.v1.internal.Status;
import io.opentelemetry.sdk.trace.data.StatusData;
import java.io.IOException;

final class SpanStatusMarshaler
extends MarshalerWithSize {
    private final ProtoEnumInfo protoStatusCode;
    private final ProtoEnumInfo deprecatedStatusCode;
    private final byte[] descriptionUtf8;

    static SpanStatusMarshaler create(StatusData status) {
        ProtoEnumInfo protoStatusCode = Status.StatusCode.STATUS_CODE_UNSET;
        ProtoEnumInfo deprecatedStatusCode = Status.DeprecatedStatusCode.DEPRECATED_STATUS_CODE_OK;
        if (status.getStatusCode() == StatusCode.OK) {
            protoStatusCode = Status.StatusCode.STATUS_CODE_OK;
        } else if (status.getStatusCode() == StatusCode.ERROR) {
            protoStatusCode = Status.StatusCode.STATUS_CODE_ERROR;
            deprecatedStatusCode = Status.DeprecatedStatusCode.DEPRECATED_STATUS_CODE_UNKNOWN_ERROR;
        }
        byte[] description = MarshalerUtil.toBytes(status.getDescription());
        return new SpanStatusMarshaler(protoStatusCode, deprecatedStatusCode, description);
    }

    private SpanStatusMarshaler(ProtoEnumInfo protoStatusCode, ProtoEnumInfo deprecatedStatusCode, byte[] descriptionUtf8) {
        super(SpanStatusMarshaler.computeSize(protoStatusCode, deprecatedStatusCode, descriptionUtf8));
        this.protoStatusCode = protoStatusCode;
        this.deprecatedStatusCode = deprecatedStatusCode;
        this.descriptionUtf8 = descriptionUtf8;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeEnum(Status.DEPRECATED_CODE, this.deprecatedStatusCode);
        output.serializeString(Status.MESSAGE, this.descriptionUtf8);
        output.serializeEnum(Status.CODE, this.protoStatusCode);
    }

    private static int computeSize(ProtoEnumInfo protoStatusCode, ProtoEnumInfo deprecatedStatusCode, byte[] descriptionUtf8) {
        int size = 0;
        size += MarshalerUtil.sizeEnum(Status.DEPRECATED_CODE, deprecatedStatusCode);
        size += MarshalerUtil.sizeBytes(Status.MESSAGE, descriptionUtf8);
        return size += MarshalerUtil.sizeEnum(Status.CODE, protoStatusCode);
    }
}

