/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.grpc;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.okhttp.OkHttpChannelBuilder;
import io.opentelemetry.exporter.internal.TlsUtil;
import io.opentelemetry.exporter.internal.retry.RetryPolicy;
import io.opentelemetry.exporter.internal.retry.RetryUtil;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class ManagedChannelUtil {
    private static final Logger logger = Logger.getLogger(ManagedChannelUtil.class.getName());

    public static void setTrustedCertificatesPem(ManagedChannelBuilder<?> managedChannelBuilder, byte[] trustedCertificatesPem) throws SSLException {
        Objects.requireNonNull(managedChannelBuilder, "managedChannelBuilder");
        Objects.requireNonNull(trustedCertificatesPem, "trustedCertificatesPem");
        X509TrustManager tmf = TlsUtil.trustManager(trustedCertificatesPem);
        if (managedChannelBuilder.getClass().getName().equals("io.grpc.netty.NettyChannelBuilder")) {
            NettyChannelBuilder nettyBuilder = (NettyChannelBuilder)managedChannelBuilder;
            nettyBuilder.sslContext(GrpcSslContexts.forClient().trustManager((TrustManager)tmf).build());
        } else if (managedChannelBuilder.getClass().getName().equals("io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder")) {
            io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder nettyBuilder = (io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder)managedChannelBuilder;
            nettyBuilder.sslContext(io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts.forClient().trustManager(tmf).build());
        } else if (managedChannelBuilder.getClass().getName().equals("io.grpc.okhttp.OkHttpChannelBuilder")) {
            OkHttpChannelBuilder okHttpBuilder = (OkHttpChannelBuilder)managedChannelBuilder;
            okHttpBuilder.sslSocketFactory(TlsUtil.sslSocketFactory(tmf));
        } else {
            throw new SSLException("TLS certificate configuration not supported for unrecognized ManagedChannelBuilder " + managedChannelBuilder.getClass().getName());
        }
    }

    public static Map<String, ?> toServiceConfig(String serviceName, RetryPolicy retryPolicy) {
        List retryableStatusCodes = RetryUtil.retryableGrpcStatusCodes().stream().map(Double::parseDouble).collect(Collectors.toList());
        HashMap<String, Object> retryConfig = new HashMap<String, Object>();
        retryConfig.put("retryableStatusCodes", retryableStatusCodes);
        retryConfig.put("maxAttempts", Double.valueOf(retryPolicy.getMaxAttempts()));
        retryConfig.put("initialBackoff", (double)retryPolicy.getInitialBackoff().toMillis() / 1000.0 + "s");
        retryConfig.put("maxBackoff", (double)retryPolicy.getMaxBackoff().toMillis() / 1000.0 + "s");
        retryConfig.put("backoffMultiplier", retryPolicy.getBackoffMultiplier());
        HashMap<String, Object> methodConfig = new HashMap<String, Object>();
        methodConfig.put("name", Collections.singletonList(Collections.singletonMap("service", serviceName)));
        methodConfig.put("retryPolicy", retryConfig);
        return Collections.singletonMap("methodConfig", Collections.singletonList(methodConfig));
    }

    public static CompletableResultCode shutdownChannel(ManagedChannel managedChannel) {
        CompletableResultCode result = new CompletableResultCode();
        managedChannel.shutdown();
        Thread thread2 = new Thread(() -> {
            try {
                managedChannel.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.log(Level.WARNING, "Failed to shutdown the gRPC channel", e);
                result.fail();
            }
            result.succeed();
        });
        thread2.setDaemon(true);
        thread2.setName("grpc-cleanup");
        thread2.start();
        return result;
    }

    private ManagedChannelUtil() {
    }
}

