/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.jfrevent;

import io.opentelemetry.sdk.trace.data.SpanData;
import jdk.jfr.Category;
import jdk.jfr.Description;
import jdk.jfr.Event;
import jdk.jfr.Label;
import jdk.jfr.Name;

@Label(value="Span")
@Name(value="io.opentelemetry.trace.Span")
@Category(value={"Open Telemetry Tracing"})
@Description(value="Open Telemetry trace event corresponding to a span.")
class SpanEvent
extends Event {
    private final String operationName;
    private final String traceId;
    private final String spanId;
    private final String parentId;

    SpanEvent(SpanData spanData) {
        this.operationName = spanData.getName();
        this.traceId = spanData.getTraceId();
        this.spanId = spanData.getSpanId();
        this.parentId = spanData.getParentSpanId();
    }

    @Label(value="Operation Name")
    public String getOperationName() {
        return this.operationName;
    }

    @Label(value="Trace Id")
    public String getTraceId() {
        return this.traceId;
    }

    @Label(value="Span Id")
    public String getSpanId() {
        return this.spanId;
    }

    @Label(value="Parent Id")
    public String getParentId() {
        return this.parentId;
    }
}

