/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.jfrevent;

import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.internal.shaded.WeakConcurrentMap;
import io.opentelemetry.contrib.jfrevent.SpanEvent;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;

public final class JfrSpanProcessor
implements SpanProcessor {
    private final WeakConcurrentMap<SpanContext, SpanEvent> spanEvents = new WeakConcurrentMap.WithInlinedExpunction();
    private volatile boolean closed;

    public void onStart(Context parentContext, ReadWriteSpan span) {
        if (this.closed) {
            return;
        }
        if (span.getSpanContext().isValid()) {
            SpanEvent event = new SpanEvent(span.toSpanData());
            event.begin();
            this.spanEvents.put((Object)span.getSpanContext(), (Object)event);
        }
    }

    public boolean isStartRequired() {
        return true;
    }

    public void onEnd(ReadableSpan rs) {
        SpanEvent event = (SpanEvent)this.spanEvents.remove((Object)rs.getSpanContext());
        if (!this.closed && event != null && event.shouldCommit()) {
            event.commit();
        }
    }

    public boolean isEndRequired() {
        return true;
    }

    public CompletableResultCode shutdown() {
        this.closed = true;
        return CompletableResultCode.ofSuccess();
    }
}

