/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.jfr.connection;

import io.opentelemetry.contrib.jfr.connection.JfrConnectionException;
import io.opentelemetry.contrib.jfr.connection.RecordingConfiguration;
import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class PredefinedConfiguration
implements RecordingConfiguration {
    private final String configurationName;

    @Override
    public void invokeSetConfiguration(long id, MBeanServerConnection mBeanServerConnection, ObjectName objectName) throws IOException, JfrConnectionException {
        try {
            Object[] args = new Object[]{id, this.configurationName};
            String[] argTypes = new String[]{Long.TYPE.getName(), String.class.getName()};
            mBeanServerConnection.invoke(objectName, "setPredefinedConfiguration", args, argTypes);
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw JfrConnectionException.canonicalJfrConnectionException(this.getClass(), "invokeSetConfiguration", e);
        }
    }

    public PredefinedConfiguration(String configurationName) {
        this.configurationName = configurationName;
    }

    public String toString() {
        return this.configurationName;
    }
}

