/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.jfr.connection;

import java.io.IOException;
import java.io.InputStream;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

class JfrStream
extends InputStream {
    private static final long DEFAULT_BLOCKSIZE = Long.getLong("jfr.stream.blocksize", 50000L);
    private byte[] buffer = new byte[0];
    private int index = 0;
    private boolean reachedEndOfFile = false;
    private final long streamid;
    private final MBeanServerConnection connection;
    private final ObjectName flightRecorder;

    public static long getDefaultBlockSize() {
        return DEFAULT_BLOCKSIZE;
    }

    JfrStream(MBeanServerConnection connection, ObjectName flightRecorder, long streamid) {
        this.streamid = streamid;
        this.connection = connection;
        this.flightRecorder = flightRecorder;
    }

    @Override
    public int read() throws IOException {
        if (!this.reachedEndOfFile && this.index == 0) {
            Object[] params = new Object[]{this.streamid};
            String[] signature = new String[]{Long.TYPE.getName()};
            try {
                this.buffer = (byte[])this.connection.invoke(this.flightRecorder, "readStream", params, signature);
            }
            catch (InstanceNotFoundException | MBeanException | ReflectionException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        if (this.reachedEndOfFile || (this.reachedEndOfFile = this.buffer == null)) {
            return -1;
        }
        int b = this.buffer[this.index] & 0xFF;
        ++this.index;
        this.index %= this.buffer.length;
        return b;
    }

    @Override
    public void close() throws IOException {
        Object[] params = new Object[]{this.streamid};
        String[] signature = new String[]{Long.TYPE.getName()};
        try {
            this.connection.invoke(this.flightRecorder, "closeStream", params, signature);
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

