/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.jfr.connection;

import io.opentelemetry.contrib.jfr.connection.FlightRecorderConnection;
import io.opentelemetry.contrib.jfr.connection.JfrConnectionException;
import io.opentelemetry.contrib.jfr.connection.JfrStream;
import io.opentelemetry.contrib.jfr.connection.OpenDataUtils;
import io.opentelemetry.contrib.jfr.connection.Recording;
import io.opentelemetry.contrib.jfr.connection.RecordingConfiguration;
import io.opentelemetry.contrib.jfr.connection.RecordingOptions;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;

final class FlightRecorderMXBeanConnection
implements FlightRecorderConnection {
    private static final String JFR_OBJECT_NAME = "jdk.management.jfr:type=FlightRecorder";
    private final MBeanServerConnection mBeanServerConnection;
    private final ObjectName objectName;

    static FlightRecorderConnection connect(MBeanServerConnection mBeanServerConnection) throws IOException, JfrConnectionException {
        Objects.requireNonNull(mBeanServerConnection);
        try {
            ObjectName objectName = new ObjectName(JFR_OBJECT_NAME);
            ObjectInstance objectInstance = mBeanServerConnection.getObjectInstance(objectName);
            return new FlightRecorderMXBeanConnection(mBeanServerConnection, objectInstance.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            throw new JfrConnectionException(JFR_OBJECT_NAME, e);
        }
        catch (InstanceNotFoundException e) {
            throw JfrConnectionException.canonicalJfrConnectionException(FlightRecorderMXBeanConnection.class, "connect", e);
        }
    }

    @Override
    public Recording newRecording(RecordingOptions recordingOptions, RecordingConfiguration recordingConfiguration) {
        return new Recording(this, recordingOptions, recordingConfiguration);
    }

    @Override
    public long startRecording(RecordingOptions recordingOptions, RecordingConfiguration recordingConfiguration) throws IOException, JfrConnectionException {
        try {
            Object[] args = new Object[]{};
            String[] argTypes = new String[]{};
            long id = (Long)this.mBeanServerConnection.invoke(this.objectName, "newRecording", args, argTypes);
            if (recordingConfiguration != null) {
                this.setConfiguration(recordingConfiguration, id);
            }
            if (recordingOptions != null) {
                this.setOptions(recordingOptions, id);
            }
            args = new Object[]{id};
            argTypes = new String[]{Long.TYPE.getName()};
            this.mBeanServerConnection.invoke(this.objectName, "startRecording", args, argTypes);
            return id;
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw JfrConnectionException.canonicalJfrConnectionException(this.getClass(), "startRecording", e);
        }
    }

    private void setOptions(RecordingOptions recordingOptions, long id) throws IOException, JfrConnectionException {
        Map<String, String> options = recordingOptions.getRecordingOptions();
        if (options != null && !options.isEmpty()) {
            try {
                TabularData recordingOptionsParam = OpenDataUtils.makeOpenData(options);
                Object[] args = new Object[]{id, recordingOptionsParam};
                String[] argTypes = new String[]{Long.TYPE.getName(), TabularData.class.getName()};
                this.mBeanServerConnection.invoke(this.objectName, "setRecordingOptions", args, argTypes);
            }
            catch (InstanceNotFoundException | MBeanException | ReflectionException | OpenDataException e) {
                throw JfrConnectionException.canonicalJfrConnectionException(this.getClass(), "setOptions", e);
            }
        }
    }

    private void setConfiguration(RecordingConfiguration recordingConfiguration, long id) throws IOException, JfrConnectionException {
        recordingConfiguration.invokeSetConfiguration(id, this.mBeanServerConnection, this.objectName);
    }

    @Override
    public void stopRecording(long id) throws IOException, JfrConnectionException {
        try {
            Object[] args = new Object[]{id};
            String[] argTypes = new String[]{Long.TYPE.getName()};
            this.mBeanServerConnection.invoke(this.objectName, "stopRecording", args, argTypes);
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw JfrConnectionException.canonicalJfrConnectionException(this.getClass(), "stopRecording", e);
        }
    }

    @Override
    public void dumpRecording(long id, String outputFile) throws IOException, JfrConnectionException {
        try {
            Object[] args = new Object[]{id, outputFile};
            String[] argTypes = new String[]{Long.TYPE.getName(), String.class.getName()};
            this.mBeanServerConnection.invoke(this.objectName, "copyTo", args, argTypes);
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw JfrConnectionException.canonicalJfrConnectionException(this.getClass(), "dumpRecording", e);
        }
    }

    @Override
    public long cloneRecording(long id, boolean stop) throws IOException, JfrConnectionException {
        try {
            Object[] args = new Object[]{id, stop};
            String[] argTypes = new String[]{Long.TYPE.getName(), Boolean.TYPE.getName()};
            return (Long)this.mBeanServerConnection.invoke(this.objectName, "cloneRecording", args, argTypes);
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw JfrConnectionException.canonicalJfrConnectionException(this.getClass(), "cloneRecording", e);
        }
    }

    @Override
    public InputStream getStream(long id, Instant startTime, Instant endTime, long blockSize) throws IOException, JfrConnectionException {
        HashMap<String, String> options = new HashMap<String, String>();
        if (startTime != null) {
            options.put("startTime", startTime.toString());
        }
        if (endTime != null) {
            options.put("endTime", endTime.toString());
        }
        if (blockSize > 0L) {
            options.put("blockSize", Long.toString(blockSize));
        }
        try {
            TabularData streamOptions = OpenDataUtils.makeOpenData(options);
            Object[] args = new Object[]{id, streamOptions};
            String[] argTypes = new String[]{Long.TYPE.getName(), TabularData.class.getName()};
            long streamId = (Long)this.mBeanServerConnection.invoke(this.objectName, "openStream", args, argTypes);
            return new JfrStream(this.mBeanServerConnection, this.objectName, streamId);
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException | OpenDataException e) {
            throw JfrConnectionException.canonicalJfrConnectionException(this.getClass(), "getStream", e);
        }
    }

    @Override
    public void closeRecording(long id) throws IOException, JfrConnectionException {
        try {
            Object[] args = new Object[]{id};
            String[] argTypes = new String[]{Long.TYPE.getName()};
            this.mBeanServerConnection.invoke(this.objectName, "closeRecording", args, argTypes);
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw JfrConnectionException.canonicalJfrConnectionException(this.getClass(), "closeRecording", e);
        }
    }

    private FlightRecorderMXBeanConnection(MBeanServerConnection mBeanServerConnection, ObjectName objectName) {
        this.mBeanServerConnection = mBeanServerConnection;
        this.objectName = objectName;
    }
}

