/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.jfr.connection;

import io.opentelemetry.contrib.jfr.connection.FlightRecorderConnection;
import io.opentelemetry.contrib.jfr.connection.JfrConnectionException;
import io.opentelemetry.contrib.jfr.connection.JfrStream;
import io.opentelemetry.contrib.jfr.connection.RecordingConfiguration;
import io.opentelemetry.contrib.jfr.connection.RecordingOptions;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public class Recording
implements AutoCloseable {
    private static final MessageFormat illegalStateFormat = new MessageFormat("Recording state {0} not in [{1}]", Locale.ROOT);
    private final FlightRecorderConnection connection;
    private final RecordingOptions recordingOptions;
    private final RecordingConfiguration recordingConfiguration;
    private volatile long id = -1L;
    private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);

    private static String createIllegalStateExceptionMessage(@Nullable State actual, State expected, State ... others) {
        String[] args = new String[]{actual != null ? actual.name() : "null", expected.name()};
        if (others != null) {
            for (State state : others) {
                args[1] = args[1].concat(", ").concat(state.name());
            }
        }
        String msg = illegalStateFormat.format(args);
        return msg;
    }

    Recording(FlightRecorderConnection connection, RecordingOptions recordingOptions, RecordingConfiguration recordingConfiguration) {
        this.connection = connection;
        this.recordingOptions = recordingOptions;
        this.recordingConfiguration = recordingConfiguration;
    }

    public long getId() {
        return this.id;
    }

    public long start() throws IOException, JfrConnectionException {
        State oldState = this.state.getAndUpdate(s -> s == State.NEW || s == State.STOPPED ? State.RECORDING : s);
        if (oldState == State.NEW || oldState == State.STOPPED) {
            this.id = this.connection.startRecording(this.recordingOptions, this.recordingConfiguration);
        } else if (oldState == State.CLOSED) {
            throw new IllegalStateException(Recording.createIllegalStateExceptionMessage(oldState, State.NEW, State.RECORDING, State.STOPPED));
        }
        return this.id;
    }

    public void stop() throws IOException, JfrConnectionException {
        State oldState = this.state.getAndUpdate(s -> s == State.RECORDING ? State.STOPPED : s);
        if (oldState == State.RECORDING) {
            this.connection.stopRecording(this.id);
        } else if (oldState == State.CLOSED) {
            throw new IllegalStateException(Recording.createIllegalStateExceptionMessage(oldState, State.NEW, State.RECORDING, State.STOPPED));
        }
    }

    public void dump(String outputFile) throws IOException, JfrConnectionException {
        Objects.requireNonNull(outputFile, "outputFile may not be null");
        State currentState = this.state.get();
        if (currentState != State.RECORDING && currentState != State.STOPPED) {
            throw new IllegalStateException(Recording.createIllegalStateExceptionMessage(currentState, State.RECORDING, State.STOPPED));
        }
        this.connection.dumpRecording(this.id, outputFile);
    }

    public Recording clone(boolean stop) throws IOException, JfrConnectionException {
        State currentState = this.state.get();
        if (currentState == State.RECORDING || currentState == State.STOPPED) {
            long newId = this.connection.cloneRecording(this.id, stop);
            Recording recordingClone = new Recording(this.connection, this.recordingOptions, this.recordingConfiguration);
            recordingClone.id = newId;
            recordingClone.state.set(stop ? State.STOPPED : currentState);
            return recordingClone;
        }
        throw new IllegalStateException(Recording.createIllegalStateExceptionMessage(currentState, State.RECORDING, State.STOPPED));
    }

    public InputStream getStream(Instant startTime, Instant endTime) throws IOException, JfrConnectionException {
        return this.getStream(startTime, endTime, JfrStream.getDefaultBlockSize());
    }

    public InputStream getStream(Instant startTime, Instant endTime, long blockSize) throws IOException, JfrConnectionException {
        State currentState = this.state.get();
        if (currentState == State.STOPPED) {
            return this.connection.getStream(this.id, startTime, endTime, blockSize);
        }
        throw new IllegalStateException(Recording.createIllegalStateExceptionMessage(currentState, State.STOPPED, new State[0]));
    }

    @Nullable
    public State getState() {
        return this.state.get();
    }

    @Override
    public void close() throws IOException, JfrConnectionException {
        State oldState = this.state.getAndSet(State.CLOSED);
        if (oldState == State.RECORDING) {
            try {
                this.connection.stopRecording(this.id);
            }
            catch (JfrConnectionException | IOException exception) {
                // empty catch block
            }
        }
        if (oldState == State.STOPPED || oldState == State.RECORDING) {
            try {
                this.connection.closeRecording(this.id);
            }
            catch (JfrConnectionException | IOException | UnsupportedOperationException exception) {
                // empty catch block
            }
        }
    }

    public static enum State {
        NEW,
        RECORDING,
        STOPPED,
        CLOSED;

    }
}

