/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.jfr.connection;

import io.opentelemetry.contrib.jfr.connection.JfrConnectionException;
import io.opentelemetry.contrib.jfr.connection.RecordingConfiguration;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class JfcFileConfiguration
implements RecordingConfiguration {
    private final String configuration;

    public JfcFileConfiguration(InputStream configurationFile) {
        this.configuration = JfcFileConfiguration.readConfigurationFile(configurationFile);
    }

    private static String readConfigurationFile(InputStream inputStream) {
        if (inputStream != null) {
            return new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining());
        }
        throw new IllegalArgumentException("Null configuration provided");
    }

    @Override
    public void invokeSetConfiguration(long id, MBeanServerConnection mBeanServerConnection, ObjectName objectName) throws IOException, JfrConnectionException {
        try {
            Object[] args = new Object[]{id, this.configuration};
            String[] argTypes = new String[]{Long.TYPE.getName(), String.class.getName()};
            mBeanServerConnection.invoke(objectName, "setConfiguration", args, argTypes);
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw JfrConnectionException.canonicalJfrConnectionException(this.getClass(), "invokeSetConfiguration", e);
        }
    }

    public String toString() {
        return this.configuration;
    }
}

