/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.jfr.connection;

import io.opentelemetry.contrib.jfr.connection.JfrConnectionException;
import io.opentelemetry.contrib.jfr.connection.OpenDataUtils;
import io.opentelemetry.contrib.jfr.connection.RecordingConfiguration;
import java.io.IOException;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;

public class MapConfiguration
implements RecordingConfiguration {
    private final Map<String, String> configuration;

    public MapConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    @Override
    public void invokeSetConfiguration(long id, MBeanServerConnection mBeanServerConnection, ObjectName objectName) throws IOException, JfrConnectionException {
        if (!this.configuration.isEmpty()) {
            try {
                TabularData configAsTabular = OpenDataUtils.makeOpenData(this.configuration);
                Object[] args = new Object[]{id, configAsTabular};
                String[] argTypes = new String[]{Long.TYPE.getName(), TabularData.class.getName()};
                mBeanServerConnection.invoke(objectName, "setRecordingSettings", args, argTypes);
            }
            catch (InstanceNotFoundException | MBeanException | ReflectionException | OpenDataException e) {
                throw JfrConnectionException.canonicalJfrConnectionException(this.getClass(), "invokeSetConfiguration", e);
            }
        }
    }

    public String toString() {
        return this.configuration.toString();
    }
}

