/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.jfr.connection;

import io.opentelemetry.contrib.jfr.connection.FlightRecorderConnection;
import io.opentelemetry.contrib.jfr.connection.JfrConnectionException;
import io.opentelemetry.contrib.jfr.connection.PredefinedConfiguration;
import io.opentelemetry.contrib.jfr.connection.Recording;
import io.opentelemetry.contrib.jfr.connection.RecordingConfiguration;
import io.opentelemetry.contrib.jfr.connection.RecordingOptions;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;

final class FlightRecorderDiagnosticCommandConnection
implements FlightRecorderConnection {
    private static final String DIAGNOSTIC_COMMAND_OBJECT_NAME = "com.sun.management:type=DiagnosticCommand";
    private static final String JFR_START_REGEX = "Started recording (\\d+?)\\.";
    private static final Pattern JFR_START_PATTERN = Pattern.compile("Started recording (\\d+?)\\.", 32);
    private static final String[] signature = new String[]{"[Ljava.lang.String;"};
    private final MBeanServerConnection mBeanServerConnection;
    private final ObjectName objectName;

    static FlightRecorderConnection connect(MBeanServerConnection mBeanServerConnection) throws IOException, JfrConnectionException {
        Objects.requireNonNull(mBeanServerConnection);
        try {
            ObjectInstance objectInstance = mBeanServerConnection.getObjectInstance(new ObjectName(DIAGNOSTIC_COMMAND_OBJECT_NAME));
            ObjectName objectName = objectInstance.getObjectName();
            if (FlightRecorderDiagnosticCommandConnection.jdkHasUnlockCommercialFeatures(mBeanServerConnection)) {
                FlightRecorderDiagnosticCommandConnection.assertCommercialFeaturesUnlocked(mBeanServerConnection, objectName);
            }
            return new FlightRecorderDiagnosticCommandConnection(mBeanServerConnection, objectInstance.getObjectName());
        }
        catch (MalformedObjectNameException e) {
            throw new JfrConnectionException(DIAGNOSTIC_COMMAND_OBJECT_NAME, e);
        }
        catch (InstanceNotFoundException e) {
            throw JfrConnectionException.canonicalJfrConnectionException(FlightRecorderDiagnosticCommandConnection.class, "connect", e);
        }
    }

    FlightRecorderDiagnosticCommandConnection(MBeanServerConnection mBeanServerConnection, ObjectName objectName) {
        this.mBeanServerConnection = mBeanServerConnection;
        this.objectName = objectName;
    }

    @Override
    public Recording newRecording(RecordingOptions recordingOptions, RecordingConfiguration recordingConfiguration) {
        return new Recording(this, recordingOptions, recordingConfiguration);
    }

    @Override
    public long startRecording(RecordingOptions recordingOptions, RecordingConfiguration recordingConfiguration) throws IOException, JfrConnectionException {
        if (!(recordingConfiguration instanceof PredefinedConfiguration)) {
            throw JfrConnectionException.canonicalJfrConnectionException(this.getClass(), "startRecording", new UnsupportedOperationException("Java 8 currently only supports predefined configurations (default/profile)"));
        }
        Object[] params = FlightRecorderDiagnosticCommandConnection.formOptions(recordingOptions, recordingConfiguration);
        try {
            String jfrStart = (String)this.mBeanServerConnection.invoke(this.objectName, "jfrStart", params, signature);
            Matcher matcher = JFR_START_PATTERN.matcher(jfrStart);
            if (matcher.find()) {
                String name = matcher.group(1);
                return Long.parseLong(name);
            }
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw JfrConnectionException.canonicalJfrConnectionException(this.getClass(), "startRecording", e);
        }
        throw JfrConnectionException.canonicalJfrConnectionException(this.getClass(), "startRecording", new IllegalStateException("Failed to parse jfrStart output"));
    }

    private static Object[] formOptions(RecordingOptions recordingOptions, RecordingConfiguration recordingConfiguration) {
        List options = recordingOptions.getRecordingOptions().entrySet().stream().filter(kv -> !((String)kv.getKey()).equals("disk")).map(kv -> (String)kv.getKey() + "=" + (String)kv.getValue()).collect(Collectors.toList());
        List<String> settings = Collections.singletonList("settings=" + recordingConfiguration);
        ArrayList<String> params = new ArrayList<String>();
        params.addAll(settings);
        params.addAll(options);
        return FlightRecorderDiagnosticCommandConnection.mkParamsArray(params);
    }

    @Override
    public void stopRecording(long id) throws JfrConnectionException {
        try {
            Object[] params = FlightRecorderDiagnosticCommandConnection.mkParams("name=" + id);
            this.mBeanServerConnection.invoke(this.objectName, "jfrStop", params, signature);
        }
        catch (IOException | InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw JfrConnectionException.canonicalJfrConnectionException(this.getClass(), "stopRecording", e);
        }
    }

    @Override
    public void dumpRecording(long id, String outputFile) throws IOException, JfrConnectionException {
        try {
            Object[] params = FlightRecorderDiagnosticCommandConnection.mkParams("filename=" + outputFile, "name=" + id);
            this.mBeanServerConnection.invoke(this.objectName, "jfrDump", params, signature);
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException e) {
            throw JfrConnectionException.canonicalJfrConnectionException(this.getClass(), "dumpRecording", e);
        }
    }

    @Override
    public long cloneRecording(long id, boolean stop) {
        throw new UnsupportedOperationException("cloneRecording not available through the DiagnosticCommand connection");
    }

    @Override
    public InputStream getStream(long id, Instant startTime, Instant endTime, long blockSize) {
        throw new UnsupportedOperationException("getStream not available through the DiagnosticCommand connection");
    }

    @Override
    public void closeRecording(long id) {
        throw new UnsupportedOperationException("closeRecording not available through the DiagnosticCommand connection");
    }

    static boolean jdkHasUnlockCommercialFeatures(MBeanServerConnection mBeanServerConnection) {
        try {
            RuntimeMXBean runtimeMxBean = ManagementFactory.getPlatformMXBean(mBeanServerConnection, RuntimeMXBean.class);
            String javaVmVendor = runtimeMxBean.getVmVendor();
            String javaVersion = runtimeMxBean.getVmVersion();
            return javaVmVendor.contains("Oracle Corporation") && javaVersion.matches("(?:^1\\.8|9|10).*");
        }
        catch (IOException e) {
            return false;
        }
    }

    static void assertCommercialFeaturesUnlocked(MBeanServerConnection mBeanServerConnection, ObjectName objectName) throws IOException, JfrConnectionException {
        try {
            boolean unlocked;
            Object unlockedMessage = mBeanServerConnection.invoke(objectName, "vmCheckCommercialFeatures", null, null);
            if (unlockedMessage instanceof String && !(unlocked = ((String)unlockedMessage).contains("unlocked"))) {
                throw JfrConnectionException.canonicalJfrConnectionException(FlightRecorderDiagnosticCommandConnection.class, "assertCommercialFeaturesUnlocked", new UnsupportedOperationException("Unlocking commercial features may be required. This must be explicitly enabled by adding -XX:+UnlockCommercialFeatures"));
            }
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException jMException) {
            // empty catch block
        }
    }

    private static Object[] mkParamsArray(List<String> args) {
        return new Object[]{args.toArray(new String[0])};
    }

    private static Object[] mkParams(String ... args) {
        return new Object[]{args};
    }
}

