/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.jfr.connection;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RecordingOptions {
    private static final String NO_LIMIT = "0";
    private final Map<String, String> recordingOptions;
    private static final Pattern durationPattern = Pattern.compile("([-+]?\\d+)\\s*(\\w*)");

    private static String normalize(String arg, Option option) {
        return arg == null || (arg = arg.trim()).isEmpty() ? option.defaultValue : arg;
    }

    private RecordingOptions(Map<String, String> recordingOptions) {
        this.recordingOptions = Collections.unmodifiableMap(recordingOptions);
    }

    public String getName() {
        return this.getOrDefault(Option.NAME);
    }

    public String getMaxAge() {
        return this.getOrDefault(Option.MAX_AGE);
    }

    public String getMaxSize() {
        return this.getOrDefault(Option.MAX_SIZE);
    }

    public String getDumpOnExit() {
        return this.recordingOptions.getOrDefault(Option.DUMP_ON_EXIT.name, Option.DUMP_ON_EXIT.defaultValue);
    }

    public String getDestination() {
        return this.getOrDefault(Option.DESTINATION);
    }

    public String getDisk() {
        return this.getOrDefault(Option.DISK);
    }

    public String getDuration() {
        return this.getOrDefault(Option.DURATION);
    }

    public Map<String, String> getRecordingOptions() {
        return this.recordingOptions;
    }

    private static String validateDuration(Option option, String durationString) {
        if (durationString == null || durationString.trim().isEmpty()) {
            return option.defaultValue;
        }
        Matcher durationStringMatcher = durationPattern.matcher(durationString);
        if (durationStringMatcher.matches()) {
            long value;
            try {
                value = Long.parseLong(durationStringMatcher.group(1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e);
            }
            if (value >= 0L) {
                String units;
                switch (units = durationStringMatcher.group(2)) {
                    case "": {
                        return Long.toString(value);
                    }
                    case "ns": 
                    case "us": 
                    case "ms": 
                    case "s": 
                    case "m": 
                    case "h": 
                    case "d": {
                        return Long.toString(value) + " " + units;
                    }
                }
            }
        }
        throw new IllegalArgumentException("bad format: " + option.name + " = \"" + durationString + "\"");
    }

    private String getOrDefault(Option option) {
        return this.recordingOptions.getOrDefault(option.name, option.defaultValue);
    }

    private static enum Option {
        NAME("name", ""),
        MAX_AGE("maxAge", "0"),
        MAX_SIZE("maxSize", "0"),
        DUMP_ON_EXIT("dumpOnExit", "false"),
        DESTINATION("destination", ""),
        DISK("disk", "false"),
        DURATION("duration", "0");

        private final String name;
        private final String defaultValue;

        private Option(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }
    }

    public static class Builder {
        private final Map<Option, String> options = new HashMap<Option, String>();

        @CanIgnoreReturnValue
        public Builder name(String name) {
            this.options.put(Option.NAME, RecordingOptions.normalize(name, Option.NAME));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder maxAge(String maxAge) {
            this.options.put(Option.MAX_AGE, RecordingOptions.validateDuration(Option.MAX_AGE, maxAge));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder maxSize(String maxSize) {
            long value = 0L;
            try {
                String numVal = RecordingOptions.normalize(maxSize, Option.MAX_SIZE);
                value = Long.parseLong(numVal);
                if (value < 0L) {
                    throw new IllegalArgumentException("maxSize: " + value + " < 0");
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e);
            }
            this.options.put(Option.MAX_SIZE, Long.toString(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder dumpOnExit(String dumpOnExit) {
            this.options.put(Option.DUMP_ON_EXIT, Boolean.valueOf(dumpOnExit).toString());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder destination(String destination) {
            this.options.put(Option.DESTINATION, RecordingOptions.normalize(destination, Option.DESTINATION));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder disk(String disk) {
            this.options.put(Option.DISK, Boolean.valueOf(RecordingOptions.normalize(disk, Option.DISK)).toString());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder duration(String duration) {
            this.options.put(Option.DURATION, RecordingOptions.validateDuration(Option.DURATION, duration));
            return this;
        }

        public RecordingOptions build() {
            Map<String, String> initRecordingOptions = Stream.of(Option.values()).filter(option -> !((Option)option).defaultValue.equals(this.options.getOrDefault(option, ((Option)option).defaultValue))).collect(Collectors.toMap(option -> ((Option)option).name, this.options::get));
            if (!initRecordingOptions.containsKey(Option.DISK.name)) {
                initRecordingOptions.put(Option.DISK.name, Option.DISK.defaultValue);
            }
            return new RecordingOptions(initRecordingOptions);
        }
    }
}

