/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.inferredspans.internal.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ThreadUtils {
    private static final MethodHandle VIRTUAL_CHECKER = ThreadUtils.generateVirtualChecker();

    private ThreadUtils() {
    }

    public static boolean isVirtual(Thread thread) {
        try {
            return VIRTUAL_CHECKER.invokeExact(thread);
        }
        catch (Throwable e) {
            throw new IllegalStateException("isVirtual is not expected to throw exceptions", e);
        }
    }

    private static MethodHandle generateVirtualChecker() {
        Method isVirtual = null;
        try {
            isVirtual = Thread.class.getMethod("isVirtual", new Class[0]);
            isVirtual.invoke((Object)Thread.currentThread(), new Object[0]);
            return MethodHandles.lookup().unreflect(isVirtual);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return MethodHandles.dropArguments(MethodHandles.constant(Boolean.TYPE, false), 0, new Class[]{Thread.class});
        }
    }
}

