/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.inferredspans.internal.util;

public class HexUtils {
    public static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    private HexUtils() {
    }

    public static void appendLongAsHex(long value, StringBuilder builder) {
        HexUtils.appendHexChar(value >> 60, builder);
        HexUtils.appendHexChar(value >> 56, builder);
        HexUtils.appendHexChar(value >> 52, builder);
        HexUtils.appendHexChar(value >> 48, builder);
        HexUtils.appendHexChar(value >> 44, builder);
        HexUtils.appendHexChar(value >> 40, builder);
        HexUtils.appendHexChar(value >> 36, builder);
        HexUtils.appendHexChar(value >> 32, builder);
        HexUtils.appendHexChar(value >> 28, builder);
        HexUtils.appendHexChar(value >> 24, builder);
        HexUtils.appendHexChar(value >> 20, builder);
        HexUtils.appendHexChar(value >> 16, builder);
        HexUtils.appendHexChar(value >> 12, builder);
        HexUtils.appendHexChar(value >> 8, builder);
        HexUtils.appendHexChar(value >> 4, builder);
        HexUtils.appendHexChar(value, builder);
    }

    private static void appendHexChar(long value, StringBuilder sb) {
        sb.append(HEX_CHARS[(int)(value & 0xFL)]);
    }

    public static long hexToLong(CharSequence hex, int offset) {
        if (hex.length() - offset < 16) {
            throw new IllegalStateException("Provided hex string '" + hex + "' is too short");
        }
        return HexUtils.hexCharToBinary(hex.charAt(offset)) << 60 | HexUtils.hexCharToBinary(hex.charAt(offset + 1)) << 56 | HexUtils.hexCharToBinary(hex.charAt(offset + 2)) << 52 | HexUtils.hexCharToBinary(hex.charAt(offset + 3)) << 48 | HexUtils.hexCharToBinary(hex.charAt(offset + 4)) << 44 | HexUtils.hexCharToBinary(hex.charAt(offset + 5)) << 40 | HexUtils.hexCharToBinary(hex.charAt(offset + 6)) << 36 | HexUtils.hexCharToBinary(hex.charAt(offset + 7)) << 32 | HexUtils.hexCharToBinary(hex.charAt(offset + 8)) << 28 | HexUtils.hexCharToBinary(hex.charAt(offset + 9)) << 24 | HexUtils.hexCharToBinary(hex.charAt(offset + 10)) << 20 | HexUtils.hexCharToBinary(hex.charAt(offset + 11)) << 16 | HexUtils.hexCharToBinary(hex.charAt(offset + 12)) << 12 | HexUtils.hexCharToBinary(hex.charAt(offset + 13)) << 8 | HexUtils.hexCharToBinary(hex.charAt(offset + 14)) << 4 | HexUtils.hexCharToBinary(hex.charAt(offset + 15));
    }

    private static long hexCharToBinary(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        if ('A' <= ch && ch <= 'F') {
            return ch - 65 + 10;
        }
        if ('a' <= ch && ch <= 'f') {
            return ch - 97 + 10;
        }
        throw new IllegalArgumentException("Not a hex char: " + ch);
    }
}

