/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.inferredspans;

import com.google.auto.service.AutoService;
import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.contrib.inferredspans.InferredSpansConfig;
import io.opentelemetry.instrumentation.config.bridge.DeclarativeConfigPropertiesBridgeBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ComponentProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import java.util.logging.Logger;

@AutoService(value={ComponentProvider.class})
public class InferredSpansSpanProcessorProvider
implements ComponentProvider {
    private static final Logger log = Logger.getLogger(InferredSpansSpanProcessorProvider.class.getName());
    private static final String PREFIX = "otel.inferred.spans.";

    public String getName() {
        return "inferred_spans/development";
    }

    public SpanProcessor create(DeclarativeConfigProperties declarativeConfigProperties) {
        DeclarativeConfigPropertiesBridgeBuilder builder = new DeclarativeConfigPropertiesBridgeBuilder();
        for (String property : InferredSpansConfig.ALL_PROPERTIES) {
            builder.addMapping(property, property.substring(PREFIX.length()).replace('.', '_'));
        }
        ConfigProperties properties = builder.build(declarativeConfigProperties);
        if (properties.getBoolean("otel.inferred.spans.enabled", true)) {
            return InferredSpansConfig.createSpanProcessor(properties);
        }
        log.finest("Not enabling inferred spans processor because enabled=false");
        return SpanProcessor.composite((SpanProcessor[])new SpanProcessor[0]);
    }

    public Class<SpanProcessor> getType() {
        return SpanProcessor.class;
    }
}

