/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.inferredspans;

import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.contrib.inferredspans.InferredSpans;
import io.opentelemetry.contrib.inferredspans.InferredSpansProcessor;
import io.opentelemetry.contrib.inferredspans.WildcardMatcher;
import io.opentelemetry.contrib.inferredspans.internal.CallTree;
import io.opentelemetry.contrib.inferredspans.internal.InferredSpansConfiguration;
import io.opentelemetry.contrib.inferredspans.internal.SpanAnchoredClock;
import java.io.File;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public class InferredSpansProcessorBuilder {
    private boolean enabled = true;
    private boolean profilerLoggingEnabled = true;
    private boolean backupDiagnosticFiles = false;
    private int asyncProfilerSafeMode = 0;
    private boolean postProcessingEnabled = true;
    private Duration samplingInterval = Duration.ofMillis(50L);
    private Duration inferredSpansMinDuration = Duration.ZERO;
    private List<WildcardMatcher> includedClasses = WildcardMatcher.matchAllList();
    private List<WildcardMatcher> excludedClasses = Arrays.asList(WildcardMatcher.caseSensitiveMatcher("java.*"), WildcardMatcher.caseSensitiveMatcher("javax.*"), WildcardMatcher.caseSensitiveMatcher("sun.*"), WildcardMatcher.caseSensitiveMatcher("com.sun.*"), WildcardMatcher.caseSensitiveMatcher("jdk.*"), WildcardMatcher.caseSensitiveMatcher("org.apache.tomcat.*"), WildcardMatcher.caseSensitiveMatcher("org.apache.catalina.*"), WildcardMatcher.caseSensitiveMatcher("org.apache.coyote.*"), WildcardMatcher.caseSensitiveMatcher("org.jboss.as.*"), WildcardMatcher.caseSensitiveMatcher("org.glassfish.*"), WildcardMatcher.caseSensitiveMatcher("org.eclipse.jetty.*"), WildcardMatcher.caseSensitiveMatcher("com.ibm.websphere.*"), WildcardMatcher.caseSensitiveMatcher("io.undertow.*"));
    private Duration profilerInterval = Duration.ofSeconds(5L);
    private Duration profilingDuration = Duration.ofSeconds(5L);
    @Nullable
    private String profilerLibDirectory = null;
    private SpanAnchoredClock clock = new SpanAnchoredClock();
    private boolean startScheduledProfiling = true;
    @Nullable
    private File activationEventsFile = null;
    @Nullable
    private File jfrFile = null;
    private BiConsumer<SpanBuilder, SpanContext> parentOverrideHandler = CallTree.DEFAULT_PARENT_OVERRIDE;

    InferredSpansProcessorBuilder() {
    }

    public InferredSpansProcessor build() {
        InferredSpansConfiguration config = new InferredSpansConfiguration(this.enabled, this.profilerLoggingEnabled, this.backupDiagnosticFiles, this.asyncProfilerSafeMode, this.postProcessingEnabled, this.samplingInterval, this.inferredSpansMinDuration, this.includedClasses, this.excludedClasses, this.profilerInterval, this.profilingDuration, this.profilerLibDirectory, this.parentOverrideHandler);
        InferredSpansProcessor processor = new InferredSpansProcessor(config, this.clock, this.startScheduledProfiling, this.activationEventsFile, this.jfrFile);
        InferredSpans.setInstance(processor);
        return processor;
    }

    public InferredSpansProcessorBuilder profilerEnabled(boolean profilerEnabled) {
        this.enabled = profilerEnabled;
        return this;
    }

    public InferredSpansProcessorBuilder profilerLoggingEnabled(boolean profilerLoggingEnabled) {
        this.profilerLoggingEnabled = profilerLoggingEnabled;
        return this;
    }

    public InferredSpansProcessorBuilder backupDiagnosticFiles(boolean backupDiagnosticFiles) {
        this.backupDiagnosticFiles = backupDiagnosticFiles;
        return this;
    }

    public InferredSpansProcessorBuilder asyncProfilerSafeMode(int asyncProfilerSafeMode) {
        this.asyncProfilerSafeMode = asyncProfilerSafeMode;
        return this;
    }

    public InferredSpansProcessorBuilder postProcessingEnabled(boolean postProcessingEnabled) {
        this.postProcessingEnabled = postProcessingEnabled;
        return this;
    }

    public InferredSpansProcessorBuilder samplingInterval(Duration samplingInterval) {
        this.samplingInterval = samplingInterval;
        return this;
    }

    public InferredSpansProcessorBuilder inferredSpansMinDuration(Duration inferredSpansMinDuration) {
        this.inferredSpansMinDuration = inferredSpansMinDuration;
        return this;
    }

    public InferredSpansProcessorBuilder includedClasses(List<WildcardMatcher> includedClasses) {
        this.includedClasses = includedClasses;
        return this;
    }

    public InferredSpansProcessorBuilder excludedClasses(List<WildcardMatcher> excludedClasses) {
        this.excludedClasses = excludedClasses;
        return this;
    }

    public InferredSpansProcessorBuilder profilerInterval(Duration profilerInterval) {
        this.profilerInterval = profilerInterval;
        return this;
    }

    public InferredSpansProcessorBuilder profilingDuration(Duration profilingDuration) {
        this.profilingDuration = profilingDuration;
        return this;
    }

    public InferredSpansProcessorBuilder profilerLibDirectory(String profilerLibDirectory) {
        this.profilerLibDirectory = profilerLibDirectory;
        return this;
    }

    public InferredSpansProcessorBuilder clock(SpanAnchoredClock clock) {
        this.clock = clock;
        return this;
    }

    public InferredSpansProcessorBuilder startScheduledProfiling(boolean startScheduledProfiling) {
        this.startScheduledProfiling = startScheduledProfiling;
        return this;
    }

    InferredSpansProcessorBuilder activationEventsFile(@Nullable File activationEventsFile) {
        this.activationEventsFile = activationEventsFile;
        return this;
    }

    InferredSpansProcessorBuilder jfrFile(@Nullable File jfrFile) {
        this.jfrFile = jfrFile;
        return this;
    }

    InferredSpansProcessorBuilder parentOverrideHandler(BiConsumer<SpanBuilder, SpanContext> handler) {
        this.parentOverrideHandler = handler;
        return this;
    }
}

