/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.inferredspans;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.Context;
import io.opentelemetry.contrib.inferredspans.InferredSpansProcessorBuilder;
import io.opentelemetry.contrib.inferredspans.internal.InferredSpansConfiguration;
import io.opentelemetry.contrib.inferredspans.internal.SamplingProfiler;
import io.opentelemetry.contrib.inferredspans.internal.SpanAnchoredClock;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class InferredSpansProcessor
implements SpanProcessor {
    private static final Logger logger = Logger.getLogger(InferredSpansProcessor.class.getName());
    public static final String TRACER_NAME = "inferred-spans";
    public static final String TRACER_VERSION = InferredSpansProcessor.readInferredSpansVersion();
    final SamplingProfiler profiler;
    private final InferredSpansConfiguration config;
    private Supplier<TracerProvider> tracerProvider = GlobalOpenTelemetry::getTracerProvider;
    @Nullable
    private volatile Tracer tracer;

    InferredSpansProcessor(InferredSpansConfiguration config, SpanAnchoredClock clock, boolean startScheduledProfiling, @Nullable File activationEventsFile, @Nullable File jfrFile) {
        this.config = config;
        this.profiler = new SamplingProfiler(config, clock, this::getTracer, activationEventsFile, jfrFile, null);
        if (startScheduledProfiling) {
            this.profiler.start();
        }
    }

    public Duration setProfilerInterval(Duration interval) {
        Duration oldInterval = this.config.setProfilerInterval(interval);
        this.profiler.reschedule();
        return oldInterval;
    }

    public static InferredSpansProcessorBuilder builder() {
        return new InferredSpansProcessorBuilder();
    }

    public synchronized void setTracerProvider(TracerProvider provider) {
        this.tracerProvider = provider == null ? GlobalOpenTelemetry::getTracerProvider : () -> provider;
    }

    public void onStart(Context parentContext, ReadWriteSpan span) {
        this.profiler.getClock().onSpanStart(span, parentContext);
    }

    public boolean isStartRequired() {
        return true;
    }

    public void onEnd(ReadableSpan span) {
    }

    public boolean isEndRequired() {
        return false;
    }

    public CompletableResultCode shutdown() {
        CompletableResultCode result = new CompletableResultCode();
        logger.fine("Stopping Inferred Spans Processor");
        ThreadFactory threadFactory = r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(false);
            thread.setName("otel-inferred-spans-shutdown");
            return thread;
        };
        Executors.newSingleThreadExecutor(threadFactory).submit(() -> {
            try {
                this.profiler.stop();
                result.succeed();
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Failed to stop Inferred Spans Processor", e);
                result.fail();
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tracer getTracer() {
        if (this.tracer == null) {
            InferredSpansProcessor inferredSpansProcessor = this;
            synchronized (inferredSpansProcessor) {
                if (this.tracer == null) {
                    this.tracer = this.tracerProvider.get().get(TRACER_NAME, TRACER_VERSION);
                }
            }
        }
        return this.tracer;
    }

    private static String readInferredSpansVersion() {
        String string;
        block8: {
            InputStream is = InferredSpansProcessor.class.getResourceAsStream("version.properties");
            try {
                Properties properties = new Properties();
                properties.load(is);
                String version = (String)properties.get("contrib.version");
                Objects.requireNonNull(version);
                string = version;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            is.close();
        }
        return string;
    }
}

