/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.inferredspans;

import com.google.auto.service.AutoService;
import io.opentelemetry.contrib.inferredspans.InferredSpansConfig;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizer;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import java.util.logging.Logger;

@AutoService(value={AutoConfigurationCustomizerProvider.class})
public class InferredSpansAutoConfig
implements AutoConfigurationCustomizerProvider {
    private static final Logger log = Logger.getLogger(InferredSpansAutoConfig.class.getName());

    public void customize(AutoConfigurationCustomizer config) {
        config.addTracerProviderCustomizer((providerBuilder, properties) -> {
            if (properties.getBoolean("otel.inferred.spans.enabled", false)) {
                providerBuilder.addSpanProcessor(InferredSpansConfig.createSpanProcessor(properties));
            } else {
                log.finest("Not enabling inferred spans processor because otel.inferred.spans.enabled is not set");
            }
            return providerBuilder;
        });
    }
}

