/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.inferredspans.internal.pooling;

import io.opentelemetry.contrib.inferredspans.internal.pooling.AbstractObjectPool;
import io.opentelemetry.contrib.inferredspans.internal.pooling.Allocator;
import io.opentelemetry.contrib.inferredspans.internal.pooling.Recyclable;
import io.opentelemetry.contrib.inferredspans.internal.pooling.Resetter;
import java.util.Queue;
import javax.annotation.Nullable;

public class QueueBasedObjectPool<T>
extends AbstractObjectPool<T> {
    private final Queue<T> queue;

    public static <T extends Recyclable> QueueBasedObjectPool<T> ofRecyclable(Queue<T> queue, boolean preAllocate, Allocator<T> allocator) {
        return new QueueBasedObjectPool<T>(queue, preAllocate, allocator, Resetter.ForRecyclable.get());
    }

    public static <T> QueueBasedObjectPool<T> of(Queue<T> queue, boolean preAllocate, Allocator<? extends T> allocator, Resetter<? super T> resetter) {
        return new QueueBasedObjectPool<T>(queue, preAllocate, allocator, resetter);
    }

    private QueueBasedObjectPool(Queue<T> queue, boolean preAllocate, Allocator<? extends T> allocator, Resetter<? super T> resetter) {
        super(allocator, resetter);
        this.queue = queue;
        if (preAllocate) {
            boolean addMore;
            while (addMore = queue.offer(allocator.createInstance())) {
            }
        }
    }

    @Override
    @Nullable
    public T tryCreateInstance() {
        return this.queue.poll();
    }

    @Override
    protected boolean returnToPool(T obj) {
        return this.queue.offer(obj);
    }

    public int getObjectsInPool() {
        return this.queue.size();
    }

    @Override
    public void clear() {
        this.queue.clear();
    }
}

