/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.inferredspans.internal.pooling;

import io.opentelemetry.contrib.inferredspans.internal.pooling.Allocator;
import io.opentelemetry.contrib.inferredspans.internal.pooling.ObjectPool;
import io.opentelemetry.contrib.inferredspans.internal.pooling.Resetter;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public abstract class AbstractObjectPool<T>
implements ObjectPool<T> {
    protected final Allocator<? extends T> allocator;
    protected final Resetter<? super T> resetter;
    private final AtomicInteger garbageCreated;

    protected AbstractObjectPool(Allocator<? extends T> allocator, Resetter<? super T> resetter) {
        this.allocator = allocator;
        this.resetter = resetter;
        this.garbageCreated = new AtomicInteger();
    }

    @Override
    public final T createInstance() {
        T object = this.tryCreateInstance();
        if (object == null) {
            object = this.allocator.createInstance();
        }
        return object;
    }

    @Override
    public final void recycle(T obj) {
        this.resetter.recycle(obj);
        if (!this.returnToPool(obj)) {
            this.garbageCreated.incrementAndGet();
        }
    }

    public final long getGarbageCreated() {
        return this.garbageCreated.longValue();
    }

    protected abstract boolean returnToPool(T var1);

    @Nullable
    protected abstract T tryCreateInstance();
}

