/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.contrib.inferredspans.internal;

import com.blogspot.mydailyjava.weaklockfree.WeakConcurrentMap;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.ReadWriteSpan;

public class SpanAnchoredClock {
    private final WeakConcurrentMap<Span, Long> nanoTimeOffsetMap = new WeakConcurrentMap.WithInlinedExpunction();

    public void onSpanStart(ReadWriteSpan started, Context parentContext) {
        Long parentAnchor;
        Span parent = Span.fromContext((Context)parentContext);
        Long l = parentAnchor = parent == null ? null : (Long)this.nanoTimeOffsetMap.get((Object)parent);
        if (parentAnchor != null) {
            this.nanoTimeOffsetMap.put((Object)started, (Object)parentAnchor);
        } else {
            long spanLatency = started.getLatencyNanos();
            long clockNowNanos = this.nanoTime();
            long spanStartNanos = started.toSpanData().getStartEpochNanos();
            long anchor = spanStartNanos - spanLatency - clockNowNanos;
            this.nanoTimeOffsetMap.put((Object)started, (Object)anchor);
        }
    }

    public long nanoTime() {
        return System.nanoTime();
    }

    public long getAnchor(Span span) {
        return (Long)this.nanoTimeOffsetMap.get((Object)span);
    }

    public long toEpochNanos(long anchor, long recordedNanoTime) {
        return recordedNanoTime + anchor;
    }
}

